/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.group.AbstractDiscretePartitionRefiner;
import org.openscience.cdk.group.AtomEquitablePartitionRefiner;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.group.PermutationGroup;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

@TestClass(value="AtomGroupTests,AtomPermutationTests,AtomDiscretePartitionRefinerTest")
public class AtomDiscretePartitionRefiner
extends AbstractDiscretePartitionRefiner {
    private int[][] connectionTable;
    private int[][] bondOrders;
    private boolean ignoreElements;
    private boolean ignoreBondOrders;

    @TestMethod(value="defaultConstructorTest")
    public AtomDiscretePartitionRefiner() {
        this(false, false);
    }

    @TestMethod(value="advancedConstructorTest")
    public AtomDiscretePartitionRefiner(boolean ignoreElements, boolean ignoreBondOrders) {
        this.ignoreElements = ignoreElements;
        this.ignoreBondOrders = ignoreBondOrders;
    }

    @TestMethod(value="getVertexCountTest")
    public int getVertexCount() {
        return this.connectionTable.length;
    }

    @TestMethod(value="getConnectivityTest")
    public int getConnectivity(int i, int j) {
        int indexInRow;
        int maxRowIndex = this.connectionTable[i].length;
        for (indexInRow = 0; indexInRow < maxRowIndex && this.connectionTable[i][indexInRow] != j; ++indexInRow) {
        }
        if (this.ignoreBondOrders) {
            if (indexInRow < maxRowIndex) {
                return 1;
            }
            return 0;
        }
        if (indexInRow < maxRowIndex) {
            return this.bondOrders[i][indexInRow];
        }
        return 0;
    }

    @TestMethod(value="getConnectedIndicesTest")
    public int[] getConnectedIndices(int atomIndex) {
        return this.connectionTable[atomIndex];
    }

    @TestMethod(value="getElementPartitionTest")
    public Partition getElementPartition(IAtomContainer atomContainer) {
        if (this.ignoreElements) {
            int n = atomContainer.getAtomCount();
            return Partition.unit(n);
        }
        if (this.connectionTable == null) {
            this.setupConnectionTable(atomContainer);
        }
        HashMap cellMap = new HashMap();
        int numberOfAtoms = atomContainer.getAtomCount();
        for (int atomIndex = 0; atomIndex < numberOfAtoms; ++atomIndex) {
            SortedSet<Integer> cell;
            String symbol = atomContainer.getAtom(atomIndex).getSymbol();
            if (cellMap.containsKey(symbol)) {
                cell = (SortedSet)cellMap.get(symbol);
            } else {
                cell = new TreeSet();
                cellMap.put(symbol, cell);
            }
            cell.add(atomIndex);
        }
        ArrayList atomSymbols = new ArrayList(cellMap.keySet());
        Collections.sort(atomSymbols);
        Partition elementPartition = new Partition();
        for (String key : atomSymbols) {
            SortedSet cell = (SortedSet)cellMap.get(key);
            elementPartition.addCell(cell);
        }
        return elementPartition;
    }

    @TestMethod(value="resetTest")
    public void reset() {
        this.connectionTable = null;
    }

    @TestMethod(value="refine_IgnoreElementsTest,refineTest")
    public void refine(IAtomContainer atomContainer) {
        this.refine(atomContainer, this.getElementPartition(atomContainer));
    }

    @TestMethod(value="refine_StartingPartitionTest")
    public void refine(IAtomContainer atomContainer, Partition partition) {
        this.setup(atomContainer);
        super.refine(partition);
    }

    @TestMethod(value="isCanonical_TrueTest,isCanonical_FalseTest")
    public boolean isCanonical(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getElementPartition(atomContainer));
        return this.isCanonical();
    }

    @TestMethod(value="getAutomorphismGroupTest")
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getElementPartition(atomContainer));
        return super.getAutomorphismGroup();
    }

    @TestMethod(value="getAutomorphismGroup_StartingGroupTest")
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, PermutationGroup group) {
        this.setup(atomContainer, group);
        super.refine(this.getElementPartition(atomContainer));
        return super.getAutomorphismGroup();
    }

    @TestMethod(value="getAutomorphismGroup_StartingPartitionTest")
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, Partition initialPartition) {
        this.setup(atomContainer);
        super.refine(initialPartition);
        return super.getAutomorphismGroup();
    }

    @TestMethod(value="getAutomorphismPartitionTest")
    public Partition getAutomorphismPartition(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getElementPartition(atomContainer));
        return super.getAutomorphismPartition();
    }

    private void setupConnectionTable(IAtomContainer atomContainer) {
        int atomCount = atomContainer.getAtomCount();
        this.connectionTable = new int[atomCount][];
        if (!this.ignoreBondOrders) {
            this.bondOrders = new int[atomCount][];
        }
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            IAtom atom = atomContainer.getAtom(atomIndex);
            List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
            int numConnAtoms = connectedAtoms.size();
            this.connectionTable[atomIndex] = new int[numConnAtoms];
            if (!this.ignoreBondOrders) {
                this.bondOrders[atomIndex] = new int[numConnAtoms];
            }
            int i = 0;
            for (IAtom connected : connectedAtoms) {
                int index;
                this.connectionTable[atomIndex][i] = index = atomContainer.getAtomNumber(connected);
                if (!this.ignoreBondOrders) {
                    int orderNumber;
                    IBond bond = atomContainer.getBond(atom, connected);
                    boolean isArom = bond.getFlag(32);
                    this.bondOrders[atomIndex][i] = orderNumber = isArom ? 5 : bond.getOrder().numeric();
                }
                ++i;
            }
        }
    }

    private void setup(IAtomContainer atomContainer) {
        if (this.connectionTable == null) {
            this.setupConnectionTable(atomContainer);
        }
        int size = this.getVertexCount();
        PermutationGroup group = new PermutationGroup(new Permutation(size));
        super.setup(group, new AtomEquitablePartitionRefiner(this));
    }

    private void setup(IAtomContainer atomContainer, PermutationGroup group) {
        this.setupConnectionTable(atomContainer);
        super.setup(group, new AtomEquitablePartitionRefiner(this));
    }
}

