/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.ImplicitHydrogenLigand;
import org.openscience.cdk.geometry.cip.LigancyFourChirality;
import org.openscience.cdk.geometry.cip.Ligand;
import org.openscience.cdk.geometry.cip.TerminalLigand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.geometry.cip.rules.CIPLigandRule;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

@TestClass(value="org.openscience.cdk.geometry.cip.CIPToolTest")
public class CIPTool {
    public static final int HYDROGEN = -1;
    private static CIPLigandRule cipRule = new CIPLigandRule();

    @TestMethod(value="testGetCIPChirality,testGetCIPChirality_Anti")
    public static CIP_CHIRALITY getCIPChirality(LigancyFourChirality stereoCenter) {
        ILigand[] ligands = CIPTool.order(stereoCenter.getLigands());
        LigancyFourChirality rsChirality = stereoCenter.project(ligands);
        boolean allAreDifferent = CIPTool.checkIfAllLigandsAreDifferent(ligands);
        if (!allAreDifferent) {
            return CIP_CHIRALITY.NONE;
        }
        if (rsChirality.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE) {
            return CIP_CHIRALITY.R;
        }
        return CIP_CHIRALITY.S;
    }

    @TestMethod(value="testGetCIPChirality_ILigancyFourChirality,testGetCIPChirality_Anti_ILigancyFourChirality")
    public static CIP_CHIRALITY getCIPChirality(IAtomContainer container, ITetrahedralChirality stereoCenter) {
        LigancyFourChirality cipLigancy = new LigancyFourChirality(container, stereoCenter);
        ILigand[] ligands = CIPTool.order(cipLigancy.getLigands());
        LigancyFourChirality rsChirality = cipLigancy.project(ligands);
        boolean allAreDifferent = CIPTool.checkIfAllLigandsAreDifferent(ligands);
        if (!allAreDifferent) {
            return CIP_CHIRALITY.NONE;
        }
        if (rsChirality.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE) {
            return CIP_CHIRALITY.R;
        }
        return CIP_CHIRALITY.S;
    }

    @TestMethod(value="testCheckIfAllLigandsAreDifferent,testCheckIfAllLigandsAreDifferent_False")
    public static boolean checkIfAllLigandsAreDifferent(ILigand[] ligands) {
        for (int i = 0; i < ligands.length - 1; ++i) {
            if (cipRule.compare(ligands[i], ligands[i + 1]) != 0) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="testOrder")
    public static ILigand[] order(ILigand[] ligands) {
        ILigand[] newLigands = new ILigand[ligands.length];
        System.arraycopy(ligands, 0, newLigands, 0, ligands.length);
        Arrays.sort(newLigands, cipRule);
        return newLigands;
    }

    @TestMethod(value="testDefineLigancyFourChirality")
    public static LigancyFourChirality defineLigancyFourChirality(IAtomContainer container, int chiralAtom, int ligand1, int ligand2, int ligand3, int ligand4, ITetrahedralChirality.Stereo stereo) {
        int[] atomIndices = new int[]{ligand1, ligand2, ligand3, ligand4};
        VisitedAtoms visitedAtoms = new VisitedAtoms();
        ILigand[] ligands = new ILigand[4];
        for (int i = 0; i < 4; ++i) {
            ligands[i] = CIPTool.defineLigand(container, visitedAtoms, chiralAtom, atomIndices[i]);
        }
        return new LigancyFourChirality(container.getAtom(chiralAtom), ligands, stereo);
    }

    @TestMethod(value="testDefineLigand")
    public static ILigand defineLigand(IAtomContainer container, VisitedAtoms visitedAtoms, int chiralAtom, int ligandAtom) {
        if (ligandAtom == -1) {
            return new ImplicitHydrogenLigand(container, visitedAtoms, container.getAtom(chiralAtom));
        }
        return new Ligand(container, visitedAtoms, container.getAtom(chiralAtom), container.getAtom(ligandAtom));
    }

    @TestMethod(value="testGetLigandLigands")
    public static ILigand[] getLigandLigands(ILigand ligand) {
        if (ligand instanceof TerminalLigand) {
            return new ILigand[0];
        }
        IAtomContainer container = ligand.getAtomContainer();
        IAtom ligandAtom = ligand.getLigandAtom();
        IAtom centralAtom = ligand.getCentralAtom();
        VisitedAtoms visitedAtoms = ligand.getVisitedAtoms();
        List<IBond> bonds = container.getConnectedBondsList(ligandAtom);
        ArrayList<Ligand> ligands = new ArrayList<Ligand>();
        for (IBond bond : bonds) {
            int duplication;
            if (bond.contains(centralAtom)) {
                if (IBond.Order.SINGLE == bond.getOrder() || (duplication = CIPTool.getDuplication(bond.getOrder()) - 1) <= 0) continue;
                for (int i = 1; i <= duplication; ++i) {
                    ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, centralAtom));
                }
                continue;
            }
            duplication = CIPTool.getDuplication(bond.getOrder());
            IAtom connectedAtom = bond.getConnectedAtom(ligandAtom);
            if (visitedAtoms.isVisited(connectedAtom)) {
                ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, connectedAtom));
            } else {
                ligands.add(new Ligand(container, visitedAtoms, ligandAtom, connectedAtom));
            }
            for (int i = 2; i <= duplication; ++i) {
                ligands.add(new TerminalLigand(container, visitedAtoms, ligandAtom, connectedAtom));
            }
        }
        return ligands.toArray(new ILigand[0]);
    }

    private static int getDuplication(IBond.Order order) {
        return order == null ? 0 : order.numeric();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CIP_CHIRALITY {
        R,
        S,
        NONE;

    }
}

