/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class ChemObject
implements Serializable,
IChemObject,
Cloneable {
    private static final long serialVersionUID = 2798134548764323328L;
    private Map<Object, Object> properties;
    private boolean[] flags;
    private String identifier;
    private boolean doNotification = true;

    public ChemObject() {
        this.flags = new boolean[13];
        this.properties = null;
        this.identifier = null;
    }

    public ChemObject(IChemObject chemObject) {
        boolean[] oldflags = chemObject.getFlags();
        this.flags = new boolean[oldflags.length];
        System.arraycopy(oldflags, 0, this.flags, 0, this.flags.length);
        this.identifier = chemObject.getID();
    }

    @Override
    public void addListener(IChemObjectListener col) {
    }

    @Override
    public int getListenerCount() {
        return 0;
    }

    @Override
    public void removeListener(IChemObjectListener col) {
    }

    @Override
    public void notifyChanged() {
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<Object, Object>();
        }
        return this.properties;
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        this.lazyProperties().remove(description);
    }

    @Override
    public Object getProperty(Object description) {
        if (this.properties != null) {
            return this.lazyProperties().get(description);
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemObject clone = (ChemObject)super.clone();
        clone.flags = new boolean[13];
        System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
        if (this.properties != null) {
            HashMap<Object, Object> clonedHashtable = new HashMap<Object, Object>();
            for (Object key : this.properties.keySet()) {
                Object value = this.properties.get(key);
                clonedHashtable.put(key, value);
            }
            clone.properties = clonedHashtable;
        }
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof IChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return this.identifier == chemObj.identifier;
    }

    @Override
    public String getID() {
        return this.identifier;
    }

    @Override
    public void setID(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.flags[flag_type] = flag_value;
    }

    @Override
    public boolean getFlag(int flag_type) {
        return this.flags[flag_type];
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        for (Object key : properties.keySet()) {
            this.lazyProperties().put(key, properties.get(key));
        }
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.flags = flagsNew;
    }

    @Override
    public boolean[] getFlags() {
        return this.flags;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }

    @Override
    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    @Override
    public boolean getNotification() {
        return this.doNotification;
    }
}

