/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import signature.chemistry.Molecule;

public class MoleculeWriter {
    public static void writeMolfile(String filename, Molecule molecule) {
        File file = new File(filename);
        try {
            MoleculeWriter.writeToStream(new FileOutputStream(file), molecule);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void writeToStream(OutputStream stream, Molecule molecule) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
            MoleculeWriter.writeHeader(writer, molecule);
            int i = 0;
            while (i < molecule.getAtomCount()) {
                MoleculeWriter.writeAtom(writer, molecule, i);
                ++i;
            }
            i = 0;
            while (i < molecule.getBondCount()) {
                MoleculeWriter.writeBond(writer, molecule, i);
                ++i;
            }
            writer.write("M  END");
            writer.newLine();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeHeader(BufferedWriter writer, Molecule molecule) throws IOException {
        writer.newLine();
        writer.write(" Writen by signature package");
        writer.newLine();
        writer.newLine();
        int a = molecule.getAtomCount();
        int b = molecule.getBondCount();
        writer.write(String.format("%3d%3d  0  0  0  0  0  0  0  0999 V2000", a, b));
        writer.newLine();
    }

    private static void writeAtom(BufferedWriter writer, Molecule molecule, int i) throws IOException {
        String empty3DCoords = "    0.0000    0.0000    0.0000 ";
        String emptyTail = " 0  0  0  0  0  0  0  0  0  0  0  0";
        String symbol = molecule.getSymbolFor(i);
        writer.write(String.valueOf(empty3DCoords) + String.format("%-3s", symbol) + emptyTail);
        writer.newLine();
    }

    private static void writeBond(BufferedWriter writer, Molecule molecule, int i) throws IOException {
        int f = molecule.getFirstInBond(i) + 1;
        int s = molecule.getSecondInBond(i) + 1;
        int o = molecule.getBondOrder(i);
        writer.write(String.format("%3d%3d%3d  0  0  0  0", f, s, o));
        writer.newLine();
    }
}

