/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.CIFFormatTest")
public class CIFFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private CIFFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new CIFFormat();
        }
        return myself;
    }

    @Override
    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "Crystallographic Interchange Format";
    }

    @Override
    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-cif";
    }

    @Override
    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"cif"};
    }

    @Override
    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.CIFReader";
    }

    @Override
    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("_cell_length_a") || line.startsWith("_audit_creation_date") || line.startsWith("loop_");
    }

    @Override
    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @Override
    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 0;
    }

    @Override
    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 0;
    }
}

