/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleCache;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.StringTokenizer;

public class Triple
implements TripleMatch {
    private final Node subj;
    private final Node pred;
    private final Node obj;
    public static final ExtendedIterator<Triple> None = new NiceIterator<Triple>();
    public static final Map1<Triple, Node> getSubject = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple t) {
            return t.getSubject();
        }
    };
    public static final Map1<Triple, Node> getPredicate = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple t) {
            return t.getPredicate();
        }
    };
    public static final Map1<Triple, Node> getObject = new Map1<Triple, Node>(){

        @Override
        public Node map1(Triple t) {
            return t.getObject();
        }
    };
    protected static TripleCache cache = new TripleCache();
    public static final Triple ANY = Triple.create(Node.ANY, Node.ANY, Node.ANY);

    public Triple(Node s, Node p, Node o) {
        if (s == null) {
            throw new UnsupportedOperationException("subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("object cannot be null");
        }
        this.subj = s;
        this.pred = p;
        this.obj = o;
    }

    public String toString() {
        return this.toString(PrefixMapping.Standard);
    }

    public String toString(PrefixMapping pm) {
        return this.subj.toString(pm, true) + " @" + this.pred.toString(pm, true) + " " + this.obj.toString(pm, true);
    }

    public final Node getSubject() {
        return this.subj;
    }

    public final Node getPredicate() {
        return this.pred;
    }

    public final Node getObject() {
        return this.obj;
    }

    public Node getMatchSubject() {
        return Triple.anyToNull(this.subj);
    }

    public Node getMatchPredicate() {
        return Triple.anyToNull(this.pred);
    }

    public Node getMatchObject() {
        return Triple.anyToNull(this.obj);
    }

    private static Node anyToNull(Node n) {
        return Node.ANY.equals(n) ? null : n;
    }

    private static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    public Triple asTriple() {
        return this;
    }

    public boolean isConcrete() {
        return this.subj.isConcrete() && this.pred.isConcrete() && this.obj.isConcrete();
    }

    public boolean equals(Object o) {
        return o instanceof Triple && ((Triple)o).sameAs(this.subj, this.pred, this.obj);
    }

    public boolean sameAs(Node s, Node p, Node o) {
        return this.subj.equals(s) && this.pred.equals(p) && this.obj.equals(o);
    }

    public boolean matches(Triple other) {
        return other.matchedBy(this.subj, this.pred, this.obj);
    }

    public boolean matches(Node s, Node p, Node o) {
        return this.subj.matches(s) && this.pred.matches(p) && this.obj.matches(o);
    }

    private boolean matchedBy(Node s, Node p, Node o) {
        return s.matches(this.subj) && p.matches(this.pred) && o.matches(this.obj);
    }

    public boolean subjectMatches(Node s) {
        return this.subj.matches(s);
    }

    public boolean predicateMatches(Node p) {
        return this.pred.matches(p);
    }

    public boolean objectMatches(Node o) {
        return this.obj.matches(o);
    }

    public int hashCode() {
        return Triple.hashCode(this.subj, this.pred, this.obj);
    }

    public static int hashCode(Node s, Node p, Node o) {
        return s.hashCode() >> 1 ^ p.hashCode() ^ o.hashCode() << 1;
    }

    public static Triple create(Node s, Node p, Node o) {
        Triple already = cache.get(s, p, o);
        return already == null ? cache.put(new Triple(s, p, o)) : already;
    }

    public static Triple createMatch(Node s, Node p, Node o) {
        return Triple.create(Triple.nullToAny(s), Triple.nullToAny(p), Triple.nullToAny(o));
    }

    public static Triple create(String fact) {
        return Triple.create(PrefixMapping.Standard, fact);
    }

    public static Triple create(PrefixMapping pm, String fact) {
        StringTokenizer st = new StringTokenizer(fact);
        Node sub = NodeCreateUtils.create((PrefixMapping)pm, (String)st.nextToken());
        Node pred = NodeCreateUtils.create((PrefixMapping)pm, (String)st.nextToken());
        Node obj = NodeCreateUtils.create((PrefixMapping)pm, (String)st.nextToken());
        return Triple.create(sub, pred, obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Field {
        protected static final Filter<Triple> anyTriple = Filter.any();
        public static final Field fieldSubject = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.subj;
            }

            @Override
            public Filter<Triple> filterOn(final Node n) {
                return n.isConcrete() ? new Filter<Triple>(){

                    @Override
                    public boolean accept(Triple x) {
                        return n.equals(x.subj);
                    }
                } : anyTriple;
            }
        };
        public static final Field fieldObject = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.obj;
            }

            @Override
            public Filter<Triple> filterOn(final Node n) {
                return n.isConcrete() ? new Filter<Triple>(){

                    @Override
                    public boolean accept(Triple x) {
                        return n.sameValueAs(x.obj);
                    }
                } : anyTriple;
            }
        };
        public static final Field fieldPredicate = new Field(){

            @Override
            public Node getField(Triple t) {
                return t.pred;
            }

            @Override
            public Filter<Triple> filterOn(final Node n) {
                return n.isConcrete() ? new Filter<Triple>(){

                    @Override
                    public boolean accept(Triple x) {
                        return n.equals(x.pred);
                    }
                } : anyTriple;
            }
        };

        public abstract Node getField(Triple var1);

        public abstract Filter<Triple> filterOn(Node var1);

        public final Filter<Triple> filterOn(Triple t) {
            return this.filterOn(this.getField(t));
        }
    }
}

