/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.IControllerModule;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;
import org.openscience.cdk.renderer.selection.AbstractSelection;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.renderer.selection.SingleSelection;

public abstract class ControllerModuleAdapter
implements IControllerModule {
    protected IChemModelRelay chemModelRelay;
    protected IChemObjectSelection selection;

    public ControllerModuleAdapter(IChemModelRelay chemModelRelay) {
        this.chemModelRelay = chemModelRelay;
    }

    public double getHighlightDistance() {
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        return (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
    }

    public static double distanceToAtom(IAtom atom, Point2d p) {
        if (atom == null) {
            return Double.MAX_VALUE;
        }
        return atom.getPoint2d().distance(p);
    }

    public static double distanceToBond(IBond bond, Point2d p) {
        if (bond == null) {
            return Double.MAX_VALUE;
        }
        return bond.get2DCenter().distance(p);
    }

    public boolean isBondOnlyInHighlightDistance(double dA, double dB, double dH) {
        return dA > dH && dB < dH;
    }

    public boolean isAtomOnlyInHighlightDistance(double dA, double dB, double dH) {
        return dA < dH && dB > dH;
    }

    public boolean noSelection(double dA, double dB, double dH) {
        return dH == Double.POSITIVE_INFINITY || dA > dH && dB > dH;
    }

    @Override
    public void mouseWheelMovedBackward(int clicks) {
    }

    @Override
    public void mouseWheelMovedForward(int clicks) {
    }

    @Override
    public void mouseClickedDouble(Point2d worldCoord) {
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
    }

    @Override
    public void mouseClickedUp(Point2d worldCoord) {
    }

    @Override
    public void mouseClickedDownRight(Point2d worldCoord) {
    }

    @Override
    public void mouseClickedUpRight(Point2d worldCoord) {
    }

    @Override
    public void mouseDrag(Point2d worldCoordFrom, Point2d worldCoordTo) {
    }

    @Override
    public void mouseEnter(Point2d worldCoord) {
    }

    @Override
    public void mouseExit(Point2d worldCoord) {
    }

    @Override
    public void mouseMove(Point2d worldCoord) {
    }

    @Override
    public void setChemModelRelay(IChemModelRelay relay) {
        this.chemModelRelay = relay;
    }

    protected IChemObject getHighlighted(Point2d worldCoord, IChemObject ... objects) {
        IChemObject closest = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (IChemObject obj : objects) {
            double distance = Double.POSITIVE_INFINITY;
            if (obj instanceof IAtom) {
                distance = ControllerModuleAdapter.distanceToAtom((IAtom)obj, worldCoord);
            } else if (obj instanceof IBond) {
                distance = ControllerModuleAdapter.distanceToBond((IBond)obj, worldCoord);
            }
            if (!(distance < minDistance)) continue;
            closest = obj;
            minDistance = distance;
        }
        if (minDistance <= this.getHighlightDistance()) {
            return closest;
        }
        return null;
    }

    protected IAtomContainer getSelectedAtomContainer(Point2d worldCoord) {
        RendererModel rModel = this.chemModelRelay.getRenderer().getRenderer2DModel();
        IAtom atom = this.chemModelRelay.getClosestAtom(worldCoord);
        IBond bond = this.chemModelRelay.getClosestBond(worldCoord);
        SingleSelection<IChemObject> localSelection = rModel.getSelection();
        IChemObject chemObject = this.getHighlighted(worldCoord, new IChemObject[]{atom, bond});
        if (chemObject != null && localSelection != null) {
            if (!localSelection.contains(chemObject)) {
                localSelection = new SingleSelection<IChemObject>(chemObject);
            }
        } else {
            localSelection = AbstractSelection.EMPTY_SELECTION;
        }
        this.setSelection(localSelection);
        return this.selection.getConnectedAtomContainer();
    }

    protected void setSelection(IChemObjectSelection selection) {
        this.selection = selection;
        this.chemModelRelay.getRenderer().getRenderer2DModel().setSelection(selection);
        this.chemModelRelay.select(null);
        this.chemModelRelay.updateView();
    }

    public IAtomContainer getModel() {
        return this.chemModelRelay.getIChemModel().getMoleculeSet().getAtomContainer(0);
    }
}

