/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.Verifier;

public final class Namespace
extends Node {
    private final String prefix;
    private final String uri;
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

    public Namespace(String prefix, String URI2, Element parent) {
        if (prefix == null) {
            prefix = "";
        } else {
            if ("xmlns".equals(prefix)) {
                throw new IllegalNameException("The xmlns prefix may not be bound to a URI.");
            }
            if ("xml".equals(prefix) && !XML_NAMESPACE.equals(URI2)) {
                throw new NamespaceConflictException("The prefix xml can only be bound to the URI http://www.w3.org/XML/1998/namespace");
            }
        }
        if (prefix.length() != 0) {
            Verifier.checkNCName(prefix);
        }
        if (URI2 == null) {
            URI2 = "";
        } else if (URI2.equals(XML_NAMESPACE) && !"xml".equals(prefix)) {
            throw new NamespaceConflictException("The URI http://www.w3.org/XML/1998/namespace can only be bound to the prefix xml");
        }
        if (URI2.length() == 0) {
            if (prefix.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(URI2);
        }
        this.prefix = prefix;
        this.uri = URI2;
        super.setParent(parent);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getValue() {
        return this.uri;
    }

    public Node getChild(int position) {
        throw new IndexOutOfBoundsException("Namespaces do not have children");
    }

    public int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Namespace(this.prefix, this.uri, null);
    }

    public void detach() {
        super.setParent(null);
    }

    public String toXML() {
        String colon = this.prefix.equals("") ? "" : ":";
        return "xmlns" + colon + this.prefix + "=\"" + this.uri + "\"";
    }

    public String toString() {
        return "[Namespace: " + this.toXML() + "]";
    }
}

