/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.PathElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.elements.path.Type;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;
import org.openscience.cdk.renderer.visitor.AbstractAWTDrawVisitor;

public class AWTDrawVisitor
extends AbstractAWTDrawVisitor {
    private AWTFontManager fontManager;
    private RendererModel rendererModel;
    private final Map<Integer, BasicStroke> strokeMap = new HashMap<Integer, BasicStroke>();
    private final Map<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
    private final Graphics2D g;
    private Color backgroundColor;

    public AWTDrawVisitor(Graphics2D g) {
        this.g = g;
        this.fontManager = null;
        this.rendererModel = null;
        this.map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        for (IGeneratorParameter<?> param : new BasicSceneGenerator().getParameters()) {
            if (!(param instanceof BasicSceneGenerator.BackgroundColor)) continue;
            this.backgroundColor = (Color)param.getDefault();
        }
    }

    public void visitElementGroup(ElementGroup elementGroup) {
        elementGroup.visitChildren(this);
    }

    public void visit(ElementGroup elementGroup) {
        elementGroup.visitChildren(this);
    }

    public void visit(ArrowElement line) {
        double scale = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        Stroke savedStroke = this.g.getStroke();
        int w = (int)(line.width * scale);
        if (this.strokeMap.containsKey(w)) {
            this.g.setStroke(this.strokeMap.get(w));
        } else {
            BasicStroke stroke = new BasicStroke(w);
            this.g.setStroke(stroke);
            this.strokeMap.put(w, stroke);
        }
        this.g.setColor(line.color);
        int[] a = this.transformPoint(line.x1, line.y1);
        int[] b = this.transformPoint(line.x2, line.y2);
        this.g.drawLine(a[0], a[1], b[0], b[1]);
        double aW = (Double)this.rendererModel.getParameter(ReactionSceneGenerator.ArrowHeadWidth.class).getValue() / scale;
        if (line.direction) {
            int[] c = this.transformPoint(line.x1 - aW, line.y1 - aW);
            int[] d = this.transformPoint(line.x1 - aW, line.y1 + aW);
            this.g.drawLine(a[0], a[1], c[0], c[1]);
            this.g.drawLine(a[0], a[1], d[0], d[1]);
        } else {
            int[] c = this.transformPoint(line.x2 + aW, line.y2 - aW);
            int[] d = this.transformPoint(line.x2 + aW, line.y2 + aW);
            this.g.drawLine(b[0], b[1], c[0], c[1]);
            this.g.drawLine(b[0], b[1], d[0], d[1]);
        }
        this.g.setStroke(savedStroke);
    }

    public void visit(LineElement line) {
        Stroke savedStroke = this.g.getStroke();
        int w = (int)(line.width * (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue());
        if (this.strokeMap.containsKey(w)) {
            this.g.setStroke(this.strokeMap.get(w));
        } else {
            BasicStroke stroke = new BasicStroke(w);
            this.g.setStroke(stroke);
            this.strokeMap.put(w, stroke);
        }
        this.g.setColor(line.color);
        int[] a = this.transformPoint(line.x1, line.y1);
        int[] b = this.transformPoint(line.x2, line.y2);
        this.g.drawLine(a[0], a[1], b[0], b[1]);
        this.g.setStroke(savedStroke);
    }

    public void visit(OvalElement oval) {
        this.g.setColor(oval.color);
        int radius = this.scaleX(oval.radius);
        int diameter = this.scaleX(oval.radius * 2.0);
        if (oval.fill) {
            this.g.fillOval(this.transformX(oval.x) - radius, this.transformY(oval.y) - radius, diameter, diameter);
        } else {
            this.g.drawOval(this.transformX(oval.x) - radius, this.transformY(oval.y) - radius, diameter, diameter);
        }
    }

    private int scaleX(double x) {
        return (int)(x * this.transform.getScaleX());
    }

    private int transformX(double x) {
        return (int)this.transform(x, 1.0)[0];
    }

    private int transformY(double y) {
        return (int)this.transform(1.0, y)[1];
    }

    private double[] transform(double x, double y) {
        double[] result = new double[2];
        this.transform.transform(new double[]{x, y}, 0, result, 0, 1);
        return result;
    }

    public void visit(TextElement textElement) {
        this.g.setFont(this.fontManager.getFont());
        Point p = this.getTextBasePoint(textElement.text, textElement.xCoord, textElement.yCoord, this.g);
        Rectangle2D textBounds = this.getTextBounds(textElement.text, textElement.xCoord, textElement.yCoord, this.g);
        this.g.setColor(this.backgroundColor);
        this.g.fill(textBounds);
        this.g.setColor(textElement.color);
        this.g.drawString(textElement.text, p.x, p.y);
    }

    public void visit(WedgeLineElement wedge) {
        Vector2d normal = new Vector2d(wedge.y1 - wedge.y2, wedge.x2 - wedge.x1);
        normal.normalize();
        normal.scale((Double)this.rendererModel.getParameter(BasicBondGenerator.WedgeWidth.class).getValue() / (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue());
        Point2d vertexA = new Point2d(wedge.x1, wedge.y1);
        Point2d vertexB = new Point2d(wedge.x2, wedge.y2);
        Point2d vertexC = new Point2d(vertexB);
        vertexB.add(normal);
        vertexC.sub(normal);
        this.g.setColor(wedge.color);
        if (wedge.isDashed) {
            this.drawDashedWedge(vertexA, vertexB, vertexC);
        } else {
            this.drawFilledWedge(vertexA, vertexB, vertexC);
        }
    }

    private void drawFilledWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        int[] pB = this.transformPoint(vertexB.x, vertexB.y);
        int[] pC = this.transformPoint(vertexC.x, vertexC.y);
        int[] pA = this.transformPoint(vertexA.x, vertexA.y);
        int[] xs = new int[]{pB[0], pC[0], pA[0]};
        int[] ys = new int[]{pB[1], pC[1], pA[1]};
        this.g.fillPolygon(xs, ys, 3);
    }

    private void drawDashedWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        Stroke storedStroke = this.g.getStroke();
        this.g.setStroke(new BasicStroke(1.0f));
        double distance = vertexB.distance(vertexA);
        double gapFactor = 0.1;
        double gap = distance * gapFactor;
        double numberOfDashes = distance / gap;
        double d = 0.0;
        int i = 0;
        while ((double)i < numberOfDashes) {
            Point2d p1 = new Point2d();
            p1.interpolate(vertexA, vertexB, d);
            Point2d p2 = new Point2d();
            p2.interpolate(vertexA, vertexC, d);
            int[] p1T = this.transformPoint(p1.x, p1.y);
            int[] p2T = this.transformPoint(p2.x, p2.y);
            this.g.drawLine(p1T[0], p1T[1], p2T[0], p2T[1]);
            if (distance * (d + gapFactor) >= distance) break;
            d += gapFactor;
            ++i;
        }
        this.g.setStroke(storedStroke);
    }

    public void visit(AtomSymbolElement atomSymbol) {
        String chargeString;
        this.g.setFont(this.fontManager.getFont());
        Point p = super.getTextBasePoint(atomSymbol.text, atomSymbol.xCoord, atomSymbol.yCoord, this.g);
        Rectangle2D textBounds = this.getTextBounds(atomSymbol.text, atomSymbol.xCoord, atomSymbol.yCoord, this.g);
        this.g.setColor(this.backgroundColor);
        this.g.fill(textBounds);
        this.g.setColor(atomSymbol.color);
        this.g.drawString(atomSymbol.text, p.x, p.y);
        int offset = 10;
        if (atomSymbol.formalCharge == 0) {
            return;
        }
        if (atomSymbol.formalCharge == 1) {
            chargeString = "+";
        } else if (atomSymbol.formalCharge > 1) {
            chargeString = atomSymbol.formalCharge + "+";
        } else if (atomSymbol.formalCharge == -1) {
            chargeString = "-";
        } else if (atomSymbol.formalCharge < -1) {
            int absCharge = Math.abs(atomSymbol.formalCharge);
            chargeString = absCharge + "-";
        } else {
            return;
        }
        int x = (int)textBounds.getCenterX();
        int y = (int)textBounds.getCenterY();
        if (atomSymbol.alignment == 1) {
            this.g.drawString(chargeString, x + offset, (int)textBounds.getMinY());
        } else if (atomSymbol.alignment == -1) {
            this.g.drawString(chargeString, x - offset, (int)textBounds.getMinY());
        } else if (atomSymbol.alignment == 2) {
            this.g.drawString(chargeString, x, y - offset);
        } else if (atomSymbol.alignment == -2) {
            this.g.drawString(chargeString, x, y + offset);
        }
    }

    public void visit(RectangleElement rectangle) {
        int[] p1 = this.transformPoint(rectangle.x, rectangle.y);
        int[] p2 = this.transformPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.g.setColor(rectangle.color);
        if (rectangle.filled) {
            this.g.fillRect(p1[0], p1[1], p2[0] - p1[0], p2[1] - p1[1]);
        } else {
            this.g.drawRect(p1[0], p1[1], p2[0] - p1[0], p2[1] - p1[1]);
        }
    }

    public void visit(PathElement path) {
        this.g.setColor(path.color);
        for (int i = 1; i < path.points.size(); ++i) {
            Point2d point1 = path.points.get(i - 1);
            Point2d point2 = path.points.get(i);
            int[] p1 = this.transformPoint(point1.x, point1.y);
            int[] p2 = this.transformPoint(point2.x, point2.y);
            this.g.drawLine(p1[0], p1[1], p2[0], p2[1]);
        }
    }

    public void visit(org.openscience.cdk.renderer.elements.GeneralPath path) {
        this.g.setColor(path.color);
        GeneralPath gp = new GeneralPath();
        gp.append(AWTDrawVisitor.getPathIterator(path, this.transform), false);
        this.g.draw(gp);
    }

    private static PathIterator getPathIterator(final org.openscience.cdk.renderer.elements.GeneralPath path, final AffineTransform transform) {
        return new PathIterator(){
            int index;

            private int type(Type type) {
                switch (type) {
                    case MoveTo: {
                        return 0;
                    }
                    case LineTo: {
                        return 1;
                    }
                    case QuadTo: {
                        return 2;
                    }
                    case CubicTo: {
                        return 3;
                    }
                    case Close: {
                        return 4;
                    }
                }
                return 4;
            }

            @Override
            public void next() {
                ++this.index;
            }

            @Override
            public boolean isDone() {
                return this.index >= path.elements.size();
            }

            @Override
            public int getWindingRule() {
                return 0;
            }

            @Override
            public int currentSegment(double[] coords) {
                float[] src = new float[6];
                int type = this.currentSegment(src);
                double[] srcD = coords;
                for (int i = 0; i < src.length; ++i) {
                    srcD[i] = src[i];
                }
                return type;
            }

            @Override
            public int currentSegment(float[] coords) {
                float[] src = path.elements.get(this.index).points();
                transform.transform(src, 0, coords, 0, src.length / 2);
                return this.type(path.elements.get(this.index).type());
            }
        };
    }

    public void visit(TextGroupElement textGroup) {
        this.g.setFont(this.fontManager.getFont());
        Point p = super.getTextBasePoint(textGroup.text, textGroup.xCoord, textGroup.yCoord, this.g);
        Rectangle2D textBounds = this.getTextBounds(textGroup.text, textGroup.xCoord, textGroup.yCoord, this.g);
        this.g.setColor(this.backgroundColor);
        this.g.fill(textBounds);
        this.g.setColor(textGroup.color);
        this.g.drawString(textGroup.text, p.x, p.y);
        int x = (int)textBounds.getCenterX();
        int y = (int)textBounds.getCenterY();
        int x1 = (int)textBounds.getMinX();
        int y1 = (int)textBounds.getMinY();
        int x2 = p.x + (int)textBounds.getWidth();
        int y2 = (int)textBounds.getMaxY();
        int oW = x2 - x1;
        int oH = y2 - y1;
        for (TextGroupElement.Child child : textGroup.children) {
            int cy;
            int cx;
            switch (child.position) {
                case NE: {
                    cx = x2;
                    cy = y1;
                    break;
                }
                case N: {
                    cx = x1;
                    cy = y1;
                    break;
                }
                case NW: {
                    cx = x1 - oW;
                    cy = y1;
                    break;
                }
                case W: {
                    cx = x1 - oW;
                    cy = p.y;
                    break;
                }
                case SW: {
                    cx = x1 - oW;
                    cy = y1 + oH;
                    break;
                }
                case S: {
                    cx = x1;
                    cy = y2 + oH;
                    break;
                }
                case SE: {
                    cx = x2;
                    cy = y2 + oH;
                    break;
                }
                case E: {
                    cx = x2;
                    cy = p.y;
                    break;
                }
                default: {
                    cx = x;
                    cy = y;
                }
            }
            this.g.drawString(child.text, cx, cy);
            if (child.subscript == null) continue;
            Rectangle2D childBounds = this.getTextBounds(child.text, cx, cy, this.g);
            int scx = (int)((double)cx + childBounds.getWidth() * 0.75);
            int scy = (int)((double)cy + childBounds.getHeight() / 3.0);
            Font f = this.g.getFont();
            Font subscriptFont = f.deriveFont(f.getStyle(), f.getSize() - 2);
            this.g.setFont(subscriptFont);
            this.g.drawString(child.subscript, scx, scy);
        }
    }

    @Override
    public void visit(IRenderingElement element) {
        Color savedColor = this.g.getColor();
        if (element instanceof ElementGroup) {
            this.visit((ElementGroup)element);
        } else if (element instanceof WedgeLineElement) {
            this.visit((WedgeLineElement)element);
        } else if (element instanceof LineElement) {
            this.visit((LineElement)element);
        } else if (element instanceof ArrowElement) {
            this.visit((ArrowElement)element);
        } else if (element instanceof OvalElement) {
            this.visit((OvalElement)element);
        } else if (element instanceof TextGroupElement) {
            this.visit((TextGroupElement)element);
        } else if (element instanceof AtomSymbolElement) {
            this.visit((AtomSymbolElement)element);
        } else if (element instanceof TextElement) {
            this.visit((TextElement)element);
        } else if (element instanceof RectangleElement) {
            this.visit((RectangleElement)element);
        } else if (element instanceof PathElement) {
            this.visit((PathElement)element);
        } else if (element instanceof org.openscience.cdk.renderer.elements.GeneralPath) {
            this.visit((org.openscience.cdk.renderer.elements.GeneralPath)element);
        } else {
            System.err.println("Visitor method for " + element.getClass().getName() + " is not implemented");
        }
        this.g.setColor(savedColor);
    }

    @Override
    public void setFontManager(IFontManager fontManager) {
        this.fontManager = (AWTFontManager)fontManager;
    }

    @Override
    public void setRendererModel(RendererModel rendererModel) {
        this.rendererModel = rendererModel;
        if (((Boolean)rendererModel.getParameter(BasicSceneGenerator.UseAntiAliasing.class).getValue()).booleanValue()) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

