/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;

public class ElementGroup
implements IRenderingElement,
Iterable<IRenderingElement> {
    private final Collection<IRenderingElement> elements = new ArrayList<IRenderingElement>();
    double scalex = 10.0;
    double scaley = 10.0;
    Rectangle2D extent;

    @Override
    public Iterator<IRenderingElement> iterator() {
        return this.elements.iterator();
    }

    public void add(IRenderingElement element) {
        if (element == null) {
            return;
        }
        this.elements.add(element);
    }

    public void visitChildren(IRenderingVisitor visitor) {
        for (IRenderingElement child : this.elements) {
            child.accept(visitor);
        }
    }

    public void setScale(double[] scale) {
        if (scale != null && scale.length != 2) {
            return;
        }
        this.scaley = this.scalex = Math.min(scale[0], scale[1]);
    }

    public double[] getDimensions(IAtomContainer ac, Dimension size) {
        Rectangle2D aSize = this.getExtent(ac);
        double[] scale = new double[]{size.getWidth() / aSize.getWidth(), size.getHeight() / aSize.getHeight()};
        this.setScale(scale);
        return scale;
    }

    public double getScale(IAtomContainer ac, Dimension size) {
        double[] scale = this.getDimensions(ac, size);
        return Math.min(scale[0], scale[1]);
    }

    Rectangle2D getExtent(IAtomContainer ac) {
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (IAtom atom : ac.atoms()) {
            double x = atom.getPoint2d().x;
            double y = atom.getPoint2d().y;
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
            ymin = Math.min(ymin, y);
            ymax = Math.max(ymax, y);
        }
        this.extent = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return this.extent;
    }

    @Override
    public void accept(IRenderingVisitor v) {
        v.visit(this);
    }

    public Point2D center(Dimension size) {
        double aWidth = this.extent.getWidth() * this.scalex;
        double aHeight = this.extent.getHeight() * -this.scaley;
        double xDiff = size.getWidth() - aWidth;
        double yDiff = size.getHeight() - aHeight;
        return new Point2D.Float((float)(-(this.extent.getX() * this.scalex) + xDiff / 2.0), (float)(-(this.extent.getY() * -this.scaley) + yDiff / 2.0));
    }
}

