/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;

public class Rotate
extends AbstractEdit {
    private double angle;
    Point2d rotationCenter;
    Collection<IAtom> atoms;

    public static Rotate rotate(Collection<IAtom> atoms, double angle, Point2d rotationCenter) {
        return new Rotate(atoms, angle, rotationCenter);
    }

    private Rotate(Collection<IAtom> atoms, double angle, Point2d rotationCenter) {
        this.angle = angle;
        this.rotationCenter = rotationCenter;
        this.atoms = new HashSet<IAtom>(atoms);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return Rotate.changed(Changed.Coordinates);
    }

    private void rotate(double angle) {
        double cosine = Math.cos(angle);
        double sine = Math.sin(angle);
        for (IAtom atom : this.atoms) {
            Point2d p = atom.getPoint2d();
            p.sub(this.rotationCenter);
            double x = p.x * cosine - p.y * sine;
            double y = p.x * sine + p.y * cosine;
            Point2d p2 = new Point2d(x, y);
            p2.add(this.rotationCenter);
            atom.setPoint2d(p2);
        }
        this.updateHydrogenCount(this.atoms);
    }

    @Override
    public void redo() {
        this.rotate(this.angle);
    }

    @Override
    public void undo() {
        this.rotate(-this.angle);
    }
}

