/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.ArrayList;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.CompositEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.controller.edit.RemoveAtom;
import org.openscience.cdk.controller.edit.RemoveBond;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.selection.AbstractSelection;

public class RemoveModule
extends ControllerModuleAdapter {
    public RemoveModule(IChemModelRelay chemObjectRelay) {
        super(chemObjectRelay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoordinate) {
        IAtomContainer selectedAC = this.getSelectedAtomContainer(worldCoordinate);
        if (selectedAC == null) {
            return;
        }
        ArrayList<IEdit> edits = new ArrayList<IEdit>();
        for (IAtom atom : selectedAC.atoms()) {
            edits.add(RemoveAtom.edit(atom));
        }
        for (IBond bond : selectedAC.bonds()) {
            edits.add(RemoveBond.remove(bond));
        }
        if (!edits.isEmpty()) {
            this.chemModelRelay.execute(CompositEdit.compose(edits));
        }
        this.setSelection(AbstractSelection.EMPTY_SELECTION);
    }

    @Override
    public String getDrawModeString() {
        return "Delete";
    }
}

