/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.RendererModel;

public class HighlightModule
extends ControllerModuleAdapter {
    private IAtom prevHighlightAtom;
    private IBond prevHighlightBond;

    public HighlightModule(IChemModelRelay chemObjectRelay) {
        super(chemObjectRelay);
        assert (chemObjectRelay != null);
    }

    private void update(IChemObject obj, RendererModel model) {
        if (obj instanceof IAtom) {
            this.updateAtom((IAtom)obj, model);
        } else if (obj instanceof IBond) {
            this.updateBond((IBond)obj, model);
        }
    }

    private void updateAtom(IAtom atom, RendererModel model) {
        if (this.prevHighlightAtom != atom) {
            model.setHighlightedAtom(atom);
            this.prevHighlightAtom = atom;
            this.prevHighlightBond = null;
            model.setHighlightedBond(null);
            this.chemModelRelay.updateView();
        }
    }

    private void updateBond(IBond bond, RendererModel model) {
        if (this.prevHighlightBond != bond) {
            model.setHighlightedBond(bond);
            this.prevHighlightBond = bond;
            this.prevHighlightAtom = null;
            model.setHighlightedAtom(null);
            this.chemModelRelay.updateView();
        }
    }

    private void unsetHighlights(RendererModel model) {
        if (this.prevHighlightAtom != null || this.prevHighlightBond != null) {
            model.setHighlightedAtom(null);
            model.setHighlightedBond(null);
            this.prevHighlightAtom = null;
            this.prevHighlightBond = null;
            this.chemModelRelay.updateView();
        }
    }

    @Override
    public void mouseMove(Point2d worldCoord) {
        IAtom atom = this.chemModelRelay.getClosestAtom(worldCoord);
        IBond bond = this.chemModelRelay.getClosestBond(worldCoord);
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        IChemObject obj = this.getHighlighted(worldCoord, new IChemObject[]{atom, bond});
        if (obj == null) {
            this.unsetHighlights(model);
        } else {
            this.update(obj, model);
        }
    }

    @Override
    public String getDrawModeString() {
        return "Highlighting";
    }
}

