/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.ArrayList;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.AddSingleElectron;
import org.openscience.cdk.controller.edit.CompositEdit;
import org.openscience.cdk.controller.edit.RemoveSingleElectron;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class ChangeSingleElectronModule
extends ControllerModuleAdapter {
    boolean add;

    public ChangeSingleElectronModule(IChemModelRelay chemModelRelay, boolean add) {
        super(chemModelRelay);
        this.add = add;
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IAtomContainer selectedAC = this.getSelectedAtomContainer(worldCoord);
        ArrayList<AbstractEdit> edits = new ArrayList<AbstractEdit>(selectedAC.getAtomCount());
        for (IAtom atom : selectedAC.atoms()) {
            if (this.add) {
                edits.add(AddSingleElectron.addElectron(atom));
                continue;
            }
            edits.add(RemoveSingleElectron.removeElectron(atom));
        }
        if (!edits.isEmpty()) {
            this.chemModelRelay.execute(CompositEdit.compose(edits));
        }
    }

    @Override
    public String getDrawModeString() {
        if (this.add) {
            return "Add Single Electron";
        }
        return "Remove Single Electron";
    }
}

