/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.AddAtom;
import org.openscience.cdk.controller.edit.SetSymbol;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;

public class AddAtomModule
extends ControllerModuleAdapter {
    public AddAtomModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IAtom closestAtom = this.chemModelRelay.getClosestAtom(worldCoord);
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        double dH = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        String atomType = this.chemModelRelay.getControlModel().getDrawElement();
        if (closestAtom == null || closestAtom.getPoint2d().distance(worldCoord) > dH) {
            this.chemModelRelay.execute(AddAtom.createAtom(atomType, worldCoord));
        } else {
            this.chemModelRelay.execute(SetSymbol.setSymbol(closestAtom, atomType));
        }
    }

    @Override
    public String getDrawModeString() {
        return "Add Atom Or Change Element";
    }
}

