/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    long handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long l;
        int n;
        long l2;
        this.fullPath = null;
        if ((this.style & 0x2002) == 2) {
            l2 = OS.gtk_file_chooser_get_filenames(this.handle);
            n = OS.g_slist_length(l2);
            this.fileNames = new String[n];
            long l3 = l2;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_slist_data(l3);
                long l5 = OS.g_filename_to_utf8(l4, -1L, null, null, null);
                OS.g_free(l4);
                if (l5 != 0L) {
                    long[] lArray = new long[1];
                    long l6 = OS.g_utf8_to_utf16(l5, -1L, null, lArray, null);
                    OS.g_free(l5);
                    if (l6 != 0L) {
                        int n3 = (int)lArray[0];
                        char[] cArray = new char[n3];
                        OS.memmove(cArray, l6, (long)(n3 * 2));
                        OS.g_free(l6);
                        this.fullPath = new String(cArray);
                        this.fileNames[n2++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                l3 = OS.g_slist_next(l3);
            }
            if (n2 != 0 && n2 != n) {
                String[] stringArray = new String[n2];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n2);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(l2);
        } else {
            l2 = OS.gtk_file_chooser_get_filename(this.handle);
            if (l2 != 0L) {
                long l7 = OS.g_filename_to_utf8(l2, -1L, null, null, null);
                OS.g_free(l2);
                if (l7 != 0L) {
                    long[] lArray = new long[1];
                    long l8 = OS.g_utf8_to_utf16(l7, -1L, null, lArray, null);
                    OS.g_free(l7);
                    if (l8 != 0L) {
                        int n4 = (int)lArray[0];
                        char[] cArray = new char[n4];
                        OS.memmove(cArray, l8, (long)(n4 * 2));
                        OS.g_free(l8);
                        this.fullPath = new String(cArray);
                        this.fileNames = new String[1];
                        this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
            }
        }
        this.filterIndex = -1;
        l2 = OS.gtk_file_chooser_get_filter(this.handle);
        if (l2 != 0L && (l = OS.gtk_file_filter_get_name(l2)) != 0L) {
            int n5 = OS.strlen(l);
            byte[] byArray = new byte[n5];
            OS.memmove(byArray, l, (long)n5);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[i].equals(string)) continue;
                    this.filterIndex = i;
                    break;
                }
                if (!this.filterExtensions[i].equals(string)) continue;
                this.filterIndex = i;
                break;
            }
        }
        if (this.fullPath != null) {
            n = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n + 1);
            this.filterPath = this.fullPath.substring(0, n);
        }
        return this.fullPath;
    }

    String computeResultClassicDialog() {
        long l;
        Object object;
        long l2;
        long[] lArray;
        long l3;
        long l4;
        this.filterIndex = -1;
        GtkFileSelection gtkFileSelection = new GtkFileSelection();
        OS.memmove(gtkFileSelection, this.handle);
        long l5 = gtkFileSelection.selection_entry;
        long l6 = OS.gtk_entry_get_text(l5);
        int n = OS.strlen(l6);
        if (n == 0) {
            int n2;
            l4 = gtkFileSelection.file_list;
            l3 = OS.gtk_tree_view_get_selection(l4);
            l2 = OS.gtk_tree_selection_get_selected_rows(l3, lArray = new long[1]);
            if (l2 == 0L) {
                return null;
            }
            int n3 = OS.g_list_length(l2);
            if (n3 == 0) {
                OS.g_list_free(l2);
                return null;
            }
            long l7 = OS.g_list_nth_data(l2, 0);
            object = new long[1];
            l = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(lArray[0], l, l7)) {
                OS.gtk_tree_model_get(lArray[0], l, 0, object, -1L);
            }
            OS.g_free(l);
            for (n2 = 0; n2 < n3; ++n2) {
                OS.gtk_tree_path_free(OS.g_list_nth_data(l2, n2));
            }
            OS.g_list_free(l2);
            if (object[0] == 0L) {
                return null;
            }
            n2 = OS.strlen(object[0]);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, object[0], (long)n2);
            OS.g_free(object[0]);
            OS.gtk_entry_set_text(l5, byArray);
        }
        l4 = OS.gtk_file_selection_get_filename(this.handle);
        l3 = OS.g_filename_to_utf8(l4, -1L, null, null, null);
        lArray = new long[1];
        l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
        n = (int)lArray[0];
        char[] cArray = new char[n];
        OS.memmove(cArray, l2, (long)(n * 2));
        String string = new String(cArray);
        OS.g_free(l2);
        OS.g_free(l3);
        if (string == null) {
            return null;
        }
        int n4 = string.lastIndexOf(SEPARATOR);
        if (n4 + 1 == string.length()) {
            return null;
        }
        this.fullPath = string;
        object = this.fullPath;
        this.fileName = this.fullPath.substring(n4 + 1);
        this.filterPath = this.fullPath.substring(0, n4);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            long l8 = l = OS.gtk_file_selection_get_selections(this.handle);
            long[] lArray2 = new long[1];
            OS.memmove(lArray2, l8, (long)OS.PTR_SIZEOF);
            int n5 = 0;
            while (lArray2[0] != 0L) {
                ++n5;
                OS.memmove(lArray2, l8 += (long)OS.PTR_SIZEOF, (long)OS.PTR_SIZEOF);
            }
            this.fileNames = new String[n5];
            lArray2 = new long[n5];
            OS.memmove(lArray2, l, (long)(n5 * OS.PTR_SIZEOF));
            for (int i = 0; i < n5; ++i) {
                l3 = OS.g_filename_to_utf8(lArray2[i], -1L, null, null, null);
                lArray = new long[1];
                l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                cArray = new char[(int)lArray[0]];
                OS.memmove(cArray, l2, lArray[0] * 2L);
                String string2 = new String(cArray);
                this.fileNames[i] = string2.substring(string2.lastIndexOf(SEPARATOR) + 1);
                OS.g_free(l2);
                OS.g_free(l3);
            }
            OS.g_strfreev(l);
        }
        return object;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        boolean bl;
        boolean bl2 = bl = OS.GTK_VERSION >= OS.VERSION(2, 4, 10);
        if (bl) {
            return this.openChooserDialog();
        }
        return this.openClassicDialog();
    }

    String openChooserDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        long l = this.parent.topHandle();
        this.handle = OS.gtk_file_chooser_dialog_new(byArray, l, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L);
        long l2 = OS.gtk_window_get_icon_list(l);
        if (l2 != 0L) {
            OS.gtk_window_set_icon_list(this.handle, l2);
            OS.g_list_free(l2);
        }
        this.presetChooserDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n2 = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, this.handle, 0L);
        }
        int n3 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l3);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n3 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    String openClassicDialog() {
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new(byArray);
        if (this.parent != null) {
            long l = this.parent.topHandle();
            OS.gtk_window_set_transient_for(this.handle, l);
            long l2 = OS.gtk_window_get_icon_list(l);
            if (l2 != 0L) {
                OS.gtk_window_set_icon_list(this.handle, l2);
                OS.g_list_free(l2);
            }
        }
        this.presetClassicDialog();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, this.handle, 0L);
        }
        int n2 = OS.gtk_dialog_run(this.handle);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n2 == -5) {
            string = this.computeResultClassicDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        long l;
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if (this.filterPath.length() > 0) {
            long l2;
            byte[] byArray;
            object = new StringBuffer();
            if (this.filterPath.charAt(0) != SEPARATOR) {
                ((StringBuffer)object).append(SEPARATOR);
            }
            ((StringBuffer)object).append(this.filterPath);
            if (this.fileName.length() > 0 && (this.style & 0x2000) == 0) {
                if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                    ((StringBuffer)object).append(SEPARATOR);
                }
                ((StringBuffer)object).append(this.fileName);
                byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
                l2 = OS.realpath(byArray, null);
                if (l2 != 0L) {
                    OS.gtk_file_chooser_set_filename(this.handle, l2);
                    OS.g_free(l2);
                }
            } else {
                byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
                l2 = OS.realpath(byArray, null);
                if (l2 != 0L) {
                    OS.gtk_file_chooser_set_current_folder(this.handle, l2);
                    OS.g_free(l2);
                }
            }
        } else if (this.fileName.length() > 0 && this.fileName.charAt(0) == SEPARATOR && (l = OS.realpath((byte[])(object = (Object)Converter.wcsToMbcs(null, this.fileName, true)), null)) != 0L) {
            OS.gtk_file_chooser_set_filename(this.handle, l);
            OS.g_free(l);
        }
        if ((this.style & 0x2000) != 0 && this.fileName.length() > 0) {
            object = Converter.wcsToMbcs(null, this.fileName, true);
            OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l3 = 0L;
        for (int i = 0; i < this.filterExtensions.length; ++i) {
            byte[] byArray;
            String string;
            byte[] byArray2;
            if (this.filterExtensions[i] == null) continue;
            long l4 = OS.gtk_file_filter_new();
            if (this.filterNames.length > i && this.filterNames[i] != null) {
                byArray2 = Converter.wcsToMbcs(null, this.filterNames[i], true);
                OS.gtk_file_filter_set_name(l4, byArray2);
            } else {
                byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[i], true);
                OS.gtk_file_filter_set_name(l4, byArray2);
            }
            int n = 0;
            int n2 = this.filterExtensions[i].indexOf(59);
            while (n2 != -1) {
                string = this.filterExtensions[i].substring(n, n2);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(l4, byArray);
                n = n2 + 1;
                n2 = this.filterExtensions[i].indexOf(59, n);
            }
            string = this.filterExtensions[i].substring(n);
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_file_filter_add_pattern(l4, byArray);
            OS.gtk_file_chooser_add_filter(this.handle, l4);
            if (i != this.filterIndex) continue;
            l3 = l4;
        }
        if (l3 != 0L) {
            OS.gtk_file_chooser_set_filter(this.handle, l3);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    void presetClassicDialog() {
        OS.gtk_file_selection_set_select_multiple(this.handle, (this.style & 2) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int n = this.fullPath.length();
        char[] cArray = new char[n + 1];
        this.fullPath.getChars(0, n, cArray, 0);
        long l = OS.g_utf16_to_utf8(cArray, -1L, null, null, null);
        long l2 = OS.g_filename_from_utf8(l, -1L, null, null, null);
        OS.gtk_file_selection_set_filename(this.handle, l2);
        OS.g_free(l);
        OS.g_free(l2);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

