/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.SMILESReaderTest")
public class SMILESReader
extends DefaultChemObjectReader {
    private BufferedReader input = null;
    private SmilesParser sp = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMILESReader.class);

    public SMILESReader(Reader input) {
        this.input = new BufferedReader(input);
        this.sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
    }

    public SMILESReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public SMILESReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IMoleculeSet.class.equals(anInterface)) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    @TestMethod(value="testReading,testReadingSmiFile_1,testReadingSmiFile_2,testReadingSmiFile_3")
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IMoleculeSet) {
            return (T)this.readMoleculeSet((IMoleculeSet)object);
        }
        if (object instanceof IChemFile) {
            IChemFile file = (IChemFile)object;
            IChemSequence sequence = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            IChemModel chemModel = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
            chemModel.setMoleculeSet(this.readMoleculeSet(file.getBuilder().newInstance(IMoleculeSet.class, new Object[0])));
            sequence.addChemModel(chemModel);
            file.addChemSequence(sequence);
            return (T)file;
        }
        throw new CDKException("Only supported is reading of MoleculeSet objects.");
    }

    private IMoleculeSet readMoleculeSet(IMoleculeSet som) {
        try {
            String line = this.input.readLine().trim();
            while (line != null) {
                logger.debug("Line: ", line);
                String[] tokens = line.split("[\\s\\t]+", 2);
                if (tokens.length > 2) {
                    throw new Exception("Malformed line");
                }
                String SMILES = tokens[0];
                String name = null;
                if (tokens.length == 2) {
                    name = tokens[1];
                }
                logger.debug("Line contains SMILES and name: ", SMILES, " + ", name);
                try {
                    IMolecule molecule = this.sp.parseSmiles(SMILES);
                    som.addMolecule(molecule);
                    if (name != null) {
                        molecule.setProperty("SMIdbNAME", name);
                    }
                }
                catch (Exception exception) {
                    logger.warn("This SMILES could not be parsed: ", SMILES);
                    logger.warn("Because of: ", exception.getMessage());
                    logger.debug(exception);
                }
                if (this.input.ready()) {
                    line = this.input.readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (Exception exception) {
            logger.error("Error while reading SMILES line: ", exception.getMessage());
            logger.debug(exception);
        }
        return som;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

