/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import com.objectplanet.image.PngEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.guha.rcdk.util.Misc;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.AtomNumberGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.ExtendedAtomGenerator;
import org.openscience.cdk.renderer.generators.RingGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class MoleculeImage {
    private IAtomContainer molecule;

    public MoleculeImage(IAtomContainer molecule) throws Exception {
        if (!ConnectivityChecker.isConnected((IAtomContainer)molecule)) {
            throw new CDKException("Molecule must be connected");
        }
        molecule = AtomContainerManipulator.removeHydrogens((IAtomContainer)molecule);
        try {
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)molecule);
        }
        catch (CDKException e) {
            throw new Exception("Error in aromatcity detection");
        }
        this.molecule = Misc.getMoleculeWithCoordinates(molecule);
    }

    public byte[] getBytes(int width, int height) throws IOException {
        Rectangle drawArea = new Rectangle(width, height);
        BufferedImage image = new BufferedImage(width, height, 1);
        ArrayList<Object> generators = new ArrayList<Object>();
        generators.add(new BasicSceneGenerator());
        generators.add(new RingGenerator());
        generators.add(new BasicBondGenerator());
        generators.add(new AtomNumberGenerator());
        generators.add(new ExtendedAtomGenerator());
        AtomContainerRenderer renderer = new AtomContainerRenderer(generators, (IFontManager)new AWTFontManager());
        renderer.setup(this.molecule, drawArea);
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        RendererModel model = renderer.getRenderer2DModel();
        model.set(AtomNumberGenerator.WillDrawAtomNumbers.class, (Object)Boolean.FALSE);
        renderer.paint(this.molecule, (IDrawVisitor)new AWTDrawVisitor(g2), (Rectangle2D)drawArea, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new PngEncoder().encode((Image)image, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer mol = sp.parseSmiles("c1ccccc1CC(=O)C1COCNC1");
        MoleculeImage mi = new MoleculeImage(mol);
        byte[] bytes = mi.getBytes(300, 300);
        FileOutputStream fos = new FileOutputStream("test.png");
        fos.write(bytes);
    }
}

