/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Viewer;

class StateManager {
    GlobalSettings globalSettings;
    Viewer viewer;
    Hashtable saved = new Hashtable();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";

    StateManager(Viewer viewer) {
        this.globalSettings = new GlobalSettings();
        this.viewer = viewer;
    }

    String listSavedStates() {
        String names = "";
        Enumeration e = this.saved.keys();
        while (e.hasMoreElements()) {
            names = names + "\n" + e.nextElement();
        }
        return names;
    }

    void saveSelection(String saveName, BitSet bsSelected) {
        saveName = this.lastSelected = "Selected_" + saveName;
        BitSet bs = (BitSet)bsSelected.clone();
        this.saved.put(saveName, bs);
    }

    boolean restoreSelection(String saveName) {
        String name = saveName.length() > 0 ? "Selected_" + saveName : this.lastSelected;
        BitSet bsSelected = (BitSet)this.saved.get(name);
        if (bsSelected == null) {
            this.viewer.select(new BitSet());
            return false;
        }
        this.viewer.select(bsSelected);
        return true;
    }

    void saveOrientation(String saveName) {
        Orientation o = new Orientation();
        o.saveName = this.lastOrientation = "Orientation_" + saveName;
        this.saved.put(o.saveName, o);
    }

    boolean restoreOrientation(String saveName, float timeSeconds) {
        String name = saveName.length() > 0 ? "Orientation_" + saveName : this.lastOrientation;
        Orientation o = (Orientation)this.saved.get(name);
        if (o == null) {
            return false;
        }
        o.restore(timeSeconds);
        return true;
    }

    void saveBonds(String saveName) {
        Connections b = new Connections();
        b.saveName = this.lastConnections = "Bonds_" + saveName;
        this.saved.put(b.saveName, b);
    }

    boolean restoreBonds(String saveName) {
        String name = saveName.length() > 0 ? "Bonds_" + saveName : this.lastConnections;
        Connections c = (Connections)this.saved.get(name);
        if (c == null) {
            return false;
        }
        c.restore();
        return true;
    }

    class GlobalSettings {
        boolean forceAutoBond;
        char inlineNewlineChar = (char)124;
        String defaultLoadScript = "";
        Point3f ptDefaultLattice = new Point3f();
        boolean allowCameraMoveFlag = true;
        boolean adjustCameraFlag = true;
        boolean solventOn;
        float solventProbeRadius = 1.2f;
        boolean measureAllModels;
        boolean enableFullSceneAntialiasing;
        boolean greyscaleRendering;
        boolean labelsGroupFlag;
        boolean labelsFrontFlag;
        boolean dotsSelectedOnlyFlag;
        boolean dotSurfaceFlag = true;
        boolean displayCellParameters = true;
        boolean showHiddenSelectionHalos = false;
        boolean showMeasurements = true;
        boolean frankOn = false;
        int axesMode = 0;
        boolean bondSelectionModeOr = false;
        boolean showMultipleBonds = true;
        boolean showHydrogens = true;
        boolean ssbondsBackbone = false;
        boolean hbondsBackbone = false;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        boolean cartoonRocketFlag;
        boolean ribbonBorder;
        boolean chainCaseSensitive;
        boolean rangeSelected;
        int pickingSpinRate = 10;
        boolean hideNameInPopup;
        boolean disablePopupMenu;
        String helpPath;
        boolean debugScript;
        boolean testFlag1;
        boolean testFlag2;
        boolean testFlag3;
        boolean testFlag4;

        GlobalSettings() {
        }

        void setDefaultLattice(Point3f ptLattice) {
            this.ptDefaultLattice.set(ptLattice);
        }

        int[] getDefaultLattice() {
            int[] A = new int[4];
            A[1] = (int)this.ptDefaultLattice.x;
            A[2] = (int)this.ptDefaultLattice.y;
            A[3] = (int)this.ptDefaultLattice.z;
            return A;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            Frame frame = StateManager.this.viewer.getFrame();
            if (frame == null) {
                return;
            }
            this.bondCount = frame.bondCount;
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bonds = frame.bonds;
            int i = this.bondCount;
            while (--i >= 0) {
                Bond b = bonds[i];
                this.connections[i] = new Connection(b.atom1.atomIndex, b.atom2.atomIndex, b.mad, b.colix, b.order, b.shapeVisibilityFlags);
            }
        }

        void restore() {
            Frame frame = StateManager.this.viewer.getFrame();
            if (frame == null) {
                return;
            }
            frame.deleteAllBonds();
            int i = this.bondCount;
            while (--i >= 0) {
                Connection c = this.connections[i];
                if (c.atomIndex1 >= frame.atomCount || c.atomIndex2 >= frame.atomCount) continue;
                Bond b = frame.bondAtoms(frame.atoms[c.atomIndex1], frame.atoms[c.atomIndex2], c.order, c.mad);
                b.colix = c.colix;
                b.shapeVisibilityFlags = c.shapeVisibilityFlags;
            }
        }

        class Connection {
            int atomIndex1;
            int atomIndex2;
            short mad;
            short colix;
            short order;
            int shapeVisibilityFlags;

            Connection(int atom1, int atom2, short mad, short colix, short order, int shapeVisibilityFlags) {
                this.atomIndex1 = atom1;
                this.atomIndex2 = atom2;
                this.mad = mad;
                this.colix = colix;
                this.order = order;
                this.shapeVisibilityFlags = shapeVisibilityFlags;
            }
        }
    }

    class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        boolean windowCenteredFlag;

        Orientation() {
            StateManager.this.viewer.getRotation(this.rotationMatrix);
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomPercentFloat();
            this.center.set(StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
        }

        void restore(float timeSeconds) {
            StateManager.this.viewer.setWindowCentered(this.windowCenteredFlag);
            StateManager.this.viewer.moveTo(timeSeconds, this.rotationMatrix, this.center, this.zoom, this.xTrans, this.yTrans, this.rotationRadius);
        }
    }
}

