/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Text;

class Labels
extends Shape {
    Atom[] atoms;
    String[] strings;
    short[] colixes;
    short[] bgcolixes;
    byte[] fids;
    int[] offsets;
    Hashtable atomLabels = new Hashtable();
    Text text;
    int defaultOffset;
    byte defaultFontId;
    short defaultColix;
    short defaultBgcolix;
    int defaultAlignment;
    String defaultPalette;
    byte zeroFontId;
    int zeroOffset;
    boolean defaultsOnlyForNone = true;

    Labels() {
    }

    void initShape() {
        this.defaultFontId = this.zeroFontId = this.g3d.getFont3D((String)"SansSerif", (String)"Plain", (int)13).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.zeroOffset = 1028;
        this.defaultOffset = 1028;
        this.atoms = this.frame.atoms;
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        int n;
        int i;
        int i2;
        if ("color" == propertyName) {
            int n2 = 0;
            String palette = null;
            short colix = Graphics3D.getColix(value);
            if (colix == 3) {
                palette = (String)value;
            }
            i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                if (!bsSelected.get(i2)) continue;
                this.setColix(i2, colix, palette, n2++);
            }
            if (n2 == 0 || !this.defaultsOnlyForNone) {
                this.defaultColix = colix;
                this.defaultPalette = palette;
            }
        }
        if ("bgcolor" == propertyName) {
            short bgcolix = Graphics3D.getColix(value);
            int n3 = 0;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setBgcolix(i, bgcolix, n3++);
            }
            if (n3 == 0 || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = bgcolix;
            }
        }
        if ("label" == propertyName) {
            String strLabel = (String)value;
            int i3 = this.frame.atomCount;
            while (--i3 >= 0) {
                Atom atom;
                if (!bsSelected.get(i3)) continue;
                String label = (atom = this.atoms[i3]).formatLabel(strLabel);
                atom.setShapeVisibility(this.myVisibilityFlag, label != null);
                if (this.strings == null || i3 >= this.strings.length) {
                    this.strings = ArrayUtil.ensureLength(this.strings, i3 + 1);
                }
                this.strings[i3] = label;
                this.text = (Text)this.atomLabels.get(this.atoms[i3]);
                if (this.text != null) {
                    this.text.setText(label);
                }
                if (this.defaultOffset != this.zeroOffset) {
                    this.setOffsets(i3, this.defaultOffset, -1);
                }
                if (this.defaultColix != 0) {
                    this.setColix(i3, this.defaultColix, this.defaultPalette, -1);
                }
                if (this.defaultBgcolix != 0) {
                    this.setBgcolix(i3, this.defaultBgcolix, -1);
                }
                if (this.defaultFontId == this.zeroFontId) continue;
                this.setFont(i3, this.defaultFontId, -1);
            }
            return;
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize < 0) {
                this.fids = null;
                return;
            }
            byte fid = this.g3d.getFontFid(fontsize);
            n = 0;
            i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                if (!bsSelected.get(i2)) continue;
                this.setFont(i2, fid, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("font" == propertyName) {
            byte fid = ((Font3D)value).fid;
            int n4 = 0;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setFont(i, fid, n4++);
            }
            if (n4 == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("offset" == propertyName) {
            int offset = (Integer)value;
            if (offset == 0) {
                offset = Short.MAX_VALUE;
            } else if (offset == this.zeroOffset) {
                offset = 0;
            }
            int n5 = 0;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setOffsets(i, offset, n5++);
            }
            if (n5 == 0 || !this.defaultsOnlyForNone) {
                this.defaultOffset = offset;
            }
            return;
        }
        if ("align" == propertyName) {
            String type = (String)value;
            int alignment = 1;
            if (type.equalsIgnoreCase("right")) {
                alignment = 3;
            } else if (type.equalsIgnoreCase("center")) {
                alignment = 2;
            }
            n = 0;
            i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                if (!bsSelected.get(i2)) continue;
                this.setAlignment(i2, alignment, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultAlignment = alignment;
            }
        }
        if ("toggleLabel" == propertyName) {
            int atomIndex = this.frame.atomCount;
            while (--atomIndex >= 0) {
                if (!bsSelected.get(atomIndex)) continue;
                Atom atom = this.atoms[atomIndex];
                if (this.strings != null && this.strings.length > atomIndex && this.strings[atomIndex] != null) {
                    this.strings[atomIndex] = null;
                } else {
                    String strLabel = this.viewer.getStandardLabelFormat();
                    this.strings = ArrayUtil.ensureLength(this.strings, atomIndex + 1);
                    this.strings[atomIndex] = atom.formatLabel(strLabel);
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings[atomIndex] != null);
                return;
            }
        }
    }

    void setColix(int i, short colix, String palette, int n) {
        if (this.colixes == null || i >= this.colixes.length) {
            if (colix == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLength(this.colixes, i + 1);
        }
        this.colixes[i] = colix != 3 ? colix : this.viewer.getColixAtomPalette(this.frame.getAtomAt(i), palette);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setColix(this.colixes[i]);
        }
    }

    void setBgcolix(int i, short bgcolix, int n) {
        if (this.bgcolixes == null || i >= this.bgcolixes.length) {
            if (bgcolix == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLength(this.bgcolixes, i + 1);
        }
        this.bgcolixes[i] = bgcolix;
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setBgColix(bgcolix);
        }
    }

    void setOffsets(int i, int offset, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (offset == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 3) + (offset << 2);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setOffset(offset);
        }
    }

    void setAlignment(int i, int alignment, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (alignment == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFFC) + alignment;
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setAlignment(alignment);
        }
    }

    void setFont(int i, byte fid, int n) {
        if (this.fids == null || i >= this.fids.length) {
            if (fid == this.defaultFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLength(this.fids, i + 1);
        }
        this.fids[i] = fid;
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setFid(fid);
        }
    }

    void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int i = this.strings.length;
        while (--i >= 0) {
            String label = this.strings[i];
            if (label == null || this.frame.atoms.length <= i || this.frame.bsHidden.get(i)) continue;
            this.frame.atoms[i].clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

