/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jmol.util.Logger;

public class GT {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private ResourceBundle[] translationResources = null;
    private int translationResourcesCount = 0;
    private static Boolean doTranslate;

    private GT() {
        String language;
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null && ((language = locale.getLanguage()).equals("") || language.equals(Locale.ENGLISH.getLanguage()))) {
            Logger.debug("English: no need for gettext wrapper");
            return;
        }
        Logger.debug("Instantiating gettext wrapper...");
        try {
            if (!ignoreApplicationBundle) {
                this.addBundles("org.jmol.translation.Jmol.Messages");
            }
        }
        catch (Exception exception) {
            Logger.error("Some exception occured!", exception);
            this.translationResources = null;
        }
        try {
            this.addBundles("org.jmol.translation.JmolApplet.Messages");
        }
        catch (Exception exception) {
            Logger.error("Some exception occured!", exception);
        }
    }

    private void addBundles(String name) {
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null) {
            if (locale.getCountry() == null || locale.getVariant() != null) {
                // empty if block
            }
            this.addBundle(name + "_" + locale.getLanguage());
        }
    }

    private void addBundle(String name) {
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> bundleClass = null;
        try {
            bundleClass = loader != null ? loader.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (bundleClass != null && ResourceBundle.class.isAssignableFrom(bundleClass)) {
            try {
                ResourceBundle myBundle = (ResourceBundle)bundleClass.newInstance();
                if (myBundle != null) {
                    if (this.translationResources == null) {
                        this.translationResources = new ResourceBundle[8];
                        this.translationResourcesCount = 0;
                    }
                    this.translationResources[this.translationResourcesCount] = myBundle;
                    ++this.translationResourcesCount;
                }
            }
            catch (IllegalAccessException e) {
                Logger.warn("Illegal Access Exception: " + e.getMessage());
            }
            catch (InstantiationException e) {
                Logger.warn("Instantiation Excaption: " + e.getMessage());
            }
        }
    }

    private static GT getTextWrapper() {
        if (getTextWrapper == null) {
            getTextWrapper = new GT();
        }
        return getTextWrapper;
    }

    public static void ignoreApplicationBundle() {
        Logger.warn("Ignore");
        ignoreApplicationBundle = true;
    }

    public static void setDoTranslate(boolean TF) {
        doTranslate = TF ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean getDoTranslate() {
        return doTranslate;
    }

    public static String _(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String _(String string, String item) {
        return GT.getTextWrapper().getString(string, new Object[]{item});
    }

    public static String _(String string, int item) {
        return GT.getTextWrapper().getString(string, new Object[]{new Integer(item)});
    }

    public static String _(String string, Object[] objects) {
        return GT.getTextWrapper().getString(string, objects);
    }

    public static String _(String string, boolean t) {
        return GT._(string, (Object[])null, t);
    }

    public static String _(String string, String item, boolean t) {
        return GT._(string, new Object[]{item});
    }

    public static String _(String string, int item, boolean t) {
        return GT._(string, new Object[]{new Integer(item)});
    }

    public static synchronized String _(String string, Object[] objects, boolean t) {
        String str;
        boolean wasTranslating = doTranslate;
        if (!wasTranslating) {
            GT.setDoTranslate(true);
        }
        String string2 = str = objects == null ? GT._(string) : GT._(string, objects);
        if (!wasTranslating) {
            GT.setDoTranslate(false);
        }
        return str;
    }

    private String getString(String string) {
        if (!doTranslate.booleanValue()) {
            return string;
        }
        for (int bundle = 0; bundle < this.translationResourcesCount; ++bundle) {
            try {
                String trans = this.translationResources[bundle].getString(string);
                return trans;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        if (this.translationResourcesCount > 0) {
            Logger.debug("No trans, using default: " + string);
        }
        return string;
    }

    private String getString(String string, Object[] objects) {
        String trans = null;
        if (!doTranslate.booleanValue()) {
            return MessageFormat.format(string, objects);
        }
        for (int bundle = 0; bundle < this.translationResourcesCount; ++bundle) {
            try {
                trans = MessageFormat.format(this.translationResources[bundle].getString(string), objects);
                return trans;
            }
            catch (MissingResourceException e) {
                continue;
            }
        }
        trans = MessageFormat.format(string, objects);
        if (this.translationResourcesCount > 0) {
            Logger.debug("No trans, using default: " + trans);
        }
        return trans;
    }

    static {
        doTranslate = new Boolean(true);
    }
}

