/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

class WebMOReader
extends AtomSetCollectionReader {
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();

    WebMOReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("webmo");
        this.readLine();
        this.modelNumber = 0;
        try {
            while (this.line != null) {
                if (this.line.equals("[HEADER]")) {
                    this.readHeader();
                    continue;
                }
                if (this.line.equals("[ATOMS]")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.equals("[BONDS]")) {
                    this.readBonds();
                    continue;
                }
                if (this.line.equals("[AO_ORDER]")) {
                    this.readAtomicOrbitalOrder();
                    continue;
                }
                if (this.line.equals("[GTO]")) {
                    this.readGaussianBasis();
                    continue;
                }
                if (this.line.equals("[STO]")) {
                    this.readSlaterBasis();
                    continue;
                }
                if (this.line.indexOf("[MO") == 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) continue;
                    this.readMolecularOrbital();
                    if (this.desiredModelNumber <= 0) continue;
                    break;
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            Logger.error("Could not read file at line: " + this.line, e);
        }
        this.logger.log(this.orbitals.size() + " molecular orbitals read");
        this.moData.put("mos", this.orbitals);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
        return this.atomSetCollection;
    }

    void readHeader() throws Exception {
        while (this.readLine() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] tokens = this.getTokens(this.line);
            tokens[0] = tokens[0].substring(0, 1).toLowerCase() + tokens[0].substring(1, tokens[0].length());
            String str = "";
            for (int i = 1; i < tokens.length; ++i) {
                str = str + (i == 1 ? "" : " ") + tokens[i].toLowerCase();
            }
            this.moData.put(tokens[0], str);
        }
    }

    void readAtoms() throws Exception {
        boolean isAtomicNumber;
        this.readLine();
        boolean bl = isAtomicNumber = this.parseInt(this.line) != Integer.MIN_VALUE;
        while (this.line != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() != 0) {
                Atom atom = this.atomSetCollection.addNewAtom();
                String[] tokens = this.getTokens(this.line);
                atom.elementSymbol = isAtomicNumber ? WebMOReader.getElementSymbol(this.parseInt(tokens[0])) : tokens[0];
                atom.x = this.parseFloat(tokens[1]) * 0.5291772f;
                atom.y = this.parseFloat(tokens[2]) * 0.5291772f;
                atom.z = this.parseFloat(tokens[3]) * 0.5291772f;
            }
            this.readLine();
        }
    }

    void readBonds() throws Exception {
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens(this.line);
            int atomIndex1 = this.parseInt(tokens[0]);
            int atomIndex2 = this.parseInt(tokens[1]);
            int order = this.parseInt(tokens[2]);
            this.atomSetCollection.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        Hashtable<String, String[]> info = new Hashtable<String, String[]>();
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens(this.line);
            info.put(tokens[0].substring(0, 1), tokens);
        }
        this.moData.put("atomicOrbitalOrder", info);
    }

    void readGaussianBasis() throws Exception {
        Vector sdata = new Vector();
        Vector<float[]> gdata = new Vector<float[]>();
        int atomIndex = 0;
        int gaussianPtr = 0;
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            String[] tokens = this.getTokens(this.line);
            if (tokens.length == 0) continue;
            if (tokens.length != 1) {
                this.logger.log("Error reading GTOs: missing atom index");
                new NullPointerException();
            }
            Hashtable<String, Object> slater = new Hashtable<String, Object>();
            atomIndex = this.parseInt(tokens[0]) - 1;
            tokens = this.getTokens(this.readLine());
            String basisType = tokens[0];
            int nGaussians = this.parseInt(tokens[1]);
            slater.put("atomIndex", new Integer(atomIndex));
            slater.put("basisType", basisType);
            slater.put("nGaussians", new Integer(nGaussians));
            slater.put("gaussianPtr", new Integer(gaussianPtr));
            for (int i = 0; i < nGaussians; ++i) {
                String[] strData = this.getTokens(this.readLine());
                int nData = strData.length;
                float[] data = new float[nData];
                for (int d = 0; d < nData; ++d) {
                    data[d] = this.parseFloat(strData[d]);
                }
                gdata.add(data);
                ++gaussianPtr;
            }
            sdata.add(slater);
        }
        float[][] garray = new float[gaussianPtr][];
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = (float[])gdata.get(i);
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        this.logger.log(sdata.size() + " slater shells read");
        this.logger.log(garray.length + " gaussian primitives read");
    }

    void readSlaterBasis() throws Exception {
        Vector<int[]> intinfo = new Vector<int[]>();
        Vector<float[]> floatinfo = new Vector<float[]>();
        int ndata = 0;
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            String[] tokens = this.getTokens(this.line);
            if (tokens.length < 7) continue;
            float[] fdata = new float[2];
            int[] idata = new int[5];
            idata[0] = this.parseInt(tokens[0]) - 1;
            for (int i = 1; i < 5; ++i) {
                idata[i] = this.parseInt(tokens[i]);
            }
            fdata[0] = this.parseFloat(tokens[5]);
            fdata[1] = this.parseFloat(tokens[6]);
            intinfo.add(idata);
            floatinfo.add(fdata);
            ++ndata;
        }
        int[][] iarray = new int[ndata][];
        for (int i = 0; i < ndata; ++i) {
            iarray[i] = (int[])intinfo.get(i);
        }
        this.moData.put("slaterInfo", iarray);
        float[][] farray = new float[ndata][];
        for (int i = 0; i < ndata; ++i) {
            farray[i] = (float[])floatinfo.get(i);
        }
        this.moData.put("slaterData", farray);
    }

    void readMolecularOrbital() throws Exception {
        Hashtable<String, Object> mo = new Hashtable<String, Object>();
        Vector<String> data = new Vector<String>();
        float energy = this.parseFloat(this.readLine());
        int occupancy = this.parseInt(this.readLine());
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens(this.line);
            data.add(tokens[1]);
        }
        float[] coefs = new float[data.size()];
        int i = data.size();
        while (--i >= 0) {
            coefs[i] = this.parseFloat((String)data.get(i));
        }
        mo.put("energy", new Float(energy));
        mo.put("occupancy", new Integer(occupancy));
        mo.put("coefficients", coefs);
        this.orbitals.add(mo);
    }
}

