/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.Atom;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.ConvertToPseudoAtomEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ConvertToPseudoAtomAction
extends JCPAction {
    private static final long serialVersionUID = -598284013998335002L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"Converting to: ", (Object)this.type);
        IChemObject object = this.getSource(event);
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        if (object != null) {
            if (object instanceof Atom) {
                Atom atom = (Atom)object;
                IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)atom);
                PseudoAtom pseudo = new PseudoAtom((IElement)atom);
                pseudo.setLabel(this.type);
                AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)atom, (IAtom)pseudo);
                ConvertToPseudoAtomEdit edit = new ConvertToPseudoAtomEdit(relevantContainer, (IAtom)atom, (IPseudoAtom)pseudo);
                this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
            } else {
                logger.error((Object)"Object not an Atom! Cannot convert into a PseudoAtom!");
            }
        } else {
            logger.warn((Object)"Cannot convert a null object!");
        }
        jcpmodel.fireChange();
    }
}

