% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_as}
\alias{write_rcdf_as}
\title{Write RCDF data to multiple formats}
\usage{
write_rcdf_as(data, path, formats, ...)
}
\arguments{
\item{data}{A named list or RCDF object. Each element should be a table or tibble-like object (typically a \code{dbplyr} or \code{dplyr} table).}

\item{path}{The target directory where output files should be saved.}

\item{formats}{A character vector of file formats to export to. Supported formats include: \code{"csv"}, \code{"tsv"}, \code{"json"}, \code{"parquet"}, \code{"xlsx"}, \code{"dta"}, \code{"sav"}, and \code{"sqlite"}.}

\item{...}{Additional arguments passed to the respective writer functions.}
}
\value{
Invisibly returns \code{NULL}. Files are written to disk.
}
\description{
Exports RCDF-formatted data to one or more supported open data formats. The function automatically dispatches to the appropriate writer function based on the \code{formats} provided.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_as(data = rcdf_data, path = temp_dir, formats = c("csv", "xlsx"))

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_csv}  \link[rcdf]{write_rcdf_tsv}  \link[rcdf]{write_rcdf_json}  \link[rcdf]{write_rcdf_xlsx}  \link[rcdf]{write_rcdf_dta}  \link[rcdf]{write_rcdf_sav}  \link[rcdf]{write_rcdf_sqlite}
}
