% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{transformSPD}
\alias{transformSPD}
\title{Apply taphonomic corrections or other transformations to an SPD.}
\usage{
transformSPD(
  x,
  correction = expression(PrDens/(5.726442 * 10^6 * (CalBP + 2176.4)^-1.3925309))
)
}
\arguments{
\item{x}{An object of class \code{CalSPD}, \code{compositeKDE} or \code{stackCalSPD}.}

\item{correction}{An expression for transforming the SPD. Available input terms include: CalBP, the vector of \code{calBP} year within the time range; and \code{PrDens}, a matching vector of summed probability. The default expression is the taphonomic correction formula proposed by Surovell et al 2009.}
}
\value{
An object of the same class as x
}
\description{
Apply taphonomic corrections or other transformations to an SPD.
}
\examples{
 
\dontrun{
data(emedyd)
region1 = subset(emedyd,Region==1)
x = calibrate(x=region1$CRA, errors=region1$Error,normalised=FALSE)
bins = binPrep(sites=region1$SiteName, ages=region1$CRA,h=50)
region1.spd = spd(x=x,bins=bins,timeRange=c(16000,8000))
region1.spd.corrected = transformSPD(region1.spd)
}
}
\references{
Surovell, T.A., Finley, J.B., Smith, G.M., Brantingham, P.J., Kelly, R., 2009. Correcting temporal frequency distributions for taphonomic bias. Journal of Archaeological Science 36, 1715–1724.
}
