% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvec.R
\name{canvec.download}
\alias{canvec.download}
\title{Download and Extract CanVec or CanVec+ Data}
\usage{
canvec.download(..., forcedownload = FALSE, forceextract = FALSE,
  extract = TRUE, cachedir = NULL)
}
\arguments{
\item{...}{A list of NTS References as generated by \code{nts()}}

\item{forcedownload}{A boolean describing if the file should be re-downloaded,
even if already present.}

\item{forceextract}{Force the exctraction of the archive even if the folder is already
present.}

\item{extract}{Pass \code{extract=FALSE} to download the archive without extracting.}

\item{cachedir}{Pass a specific cache directory in which to download and extract the file.
Default value is that returned by \code{canvec.cachedir()}}
}
\description{
Downloads CanVec or CanVec+ data (as applicable) to \code{cachedir} and extracts the archive.
}
\examples{
\donttest{
canvec.download(nts('21h1'))
}

}

