% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlm.R
\docType{package}
\name{rlm}
\alias{rlm}
\alias{rlm-package}
\alias{rlm}
\title{RCANE}
\usage{
rlm(formula, data, method = "sgd", alpha = 0.1, max.iter = 1000,
  precision = 1e-04, boldDriver = FALSE, AdaGrad = FALSE, ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{method}{the method to be used. Possible values include "bgd", "sgd", "cd" and "mini-bgd".}

\item{alpha}{the learning rate - typically this would be set to the optimum value}

\item{max.iter}{the maximum number of iterations - in case of delayed convergence, the function would terminate after max.iter iterations}

\item{precision}{the precision of the result}

\item{boldDriver}{set \code{TRUE} to use bold driver for method='bgd'}

\item{AdaGrad}{set \code{TRUE} to use AdaGrad for method='sgd'}

\item{...}{additional arguments to be passed to the low level regression fitting functions.}
}
\description{
RCANE

Gradient descent is a first-order iterative optimization algorithm for finding the minimum of a function.
bgd (Batch Gradient Descent) - Batch Gradient Descent updates the parameters by computing loss function of the entire dataset.
sgd (Stochastic Gradient Descent) - Stochastic Gradient Descent updates the parametes by computing loss function for each record in
the dataset.
cd (Coordinate Descent) - Coordinate Descent updates the parameter by minimizing the loss function along each coordinate axis.
mini-bgd (Mini Batch Gradient Descent) - Mini Batch Gradient Descent divides the data into batches and updates the parameters by computing the loss 
function for each batch.
}
\details{
\code{rlm} is an interface for the optimization functions written in the rcane project.
}
\examples{
library(datasets)
rlm(mpg ~ disp, data = mtcars, alpha = 0.00001)

}
