% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/measures.R
\name{lasso.coef}
\alias{lasso.coef}
\title{Measure an impact of the covariates on the response using Lasso
This function evaluates the Lasso coefficients regressing \code{y} onto the design matrix \code{x} over subsamples in \code{subsamples}.}
\usage{
lasso.coef(x, y, subsamples, nonzero = NULL, family = c("gaussian",
  "binomial"), alpha = 1, maxit = 500, tol = 0.01, lambda.ratio = 1e-06,
  nlam = 25, ...)
}
\arguments{
\item{x}{Matrix with \code{n} observations of \code{p} covariates in each row.}

\item{y}{Response vector with \code{n} observations.}

\item{subsamples}{Matrix with \code{m} indices of \code{N} subsamples in each column.}

\item{nonzero}{Number of non-zero coefficients estimated for each subsample.}

\item{family}{Determines the likelihood optimised in the estimation procedure.}

\item{alpha}{Scalar between 0 and 1 determining l2 penalty (see details).}

\item{maxit}{Maximum number of itarations when computing the lasso coefficients.}

\item{tol}{Scalar determining convergence of the lasso algorithm used.}

\item{lambda.ratio}{Scalar being a fraction of 1. Used in the lasso algorithm}

\item{nlam}{Number of penalty parameters used in the lasso algorithm.}

\item{...}{Not in use.}
}
\description{
Measure an impact of the covariates on the response using Lasso
This function evaluates the Lasso coefficients regressing \code{y} onto the design matrix \code{x} over subsamples in \code{subsamples}.
}
\details{
To solve the Lasso problem, we implement the coordinate descent algorithm as in Breheny Jian (2011).
}
\author{
Rafal Baranowski, Patrick Breheny
}
\references{
Tibshirani, Robert. "Regression shrinkage and selection via the lasso." Journal of the Royal Statistical Society. Series B (Methodological) (1996): 267-288.

Breheny, Patrick, and Jian Huang. "Coordinate descent algorithms for nonconvex penalized regression, with applications to biological feature selection." The Annals of Applied Statistics 5.1 (2011): 232.
}

