% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_data_individual}
\alias{impute_data_individual}
\title{Impute data for a single subject}
\usage{
impute_data_individual(
  id,
  index,
  beta,
  sigma,
  data,
  references,
  strategies,
  condmean,
  n_imputations = 1
)
}
\arguments{
\item{id}{Character string identifying the subject.}

\item{index}{The sample indexes which the subject belongs to e.g \code{c(1,1,1,2,2,4)}.}

\item{beta}{A list of beta coefficients for each sample, i.e. \code{beta[[1]]} is the set of
beta coefficients for the first sample.}

\item{sigma}{A list of the sigma coefficients for each sample split by group i.e.
\code{sigma[[1]][["A"]]} would give the sigma coefficients for group A for the first sample.}

\item{data}{A \code{longdata} object created by \code{\link[=longDataConstructor]{longDataConstructor()}}}

\item{references}{A named vector. Identifies the references to be used when generating the
imputed values. Should be of the form \code{c("Group" = "Reference", "Group" = "Reference")}.}

\item{strategies}{A named list of functions. Defines the imputation functions to be used.
The names of the list should mirror the values specified in \code{method} column of \code{data_ice}.
Default = \code{getStrategies()}. See \code{\link[=getStrategies]{getStrategies()}} for more details.}

\item{condmean}{Logical. If \code{TRUE} will impute using the conditional mean values, if \code{FALSE}
will impute by taking a random draw from the multivariate normal distribution.}

\item{n_imputations}{When \code{condmean = FALSE} numeric representing the number of random
imputations to be performed for each sample.
Default is \code{1} (one random imputation per sample).}
}
\description{
This function performs the imputation for a single subject at a time implementing the
process as detailed in \code{\link[=impute]{impute()}}.
}
\details{
Note that this function performs all of the required imputations for a subject at the
same time. I.e. if a subject is included in samples  1,3,5,9 then all imputations (using
sample-dependent imputation model parameters) are performed in one step in order to avoid
having to look up a subjects's covariates and expanding them to a design matrix multiple times
(which would be more computationally expensive).
The function also supports subject belonging to the same sample multiple times,
i.e. 1,1,2,3,5,5, as will typically occur for bootstrapped datasets.
}
