% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{get_conditional_parameters}
\alias{get_conditional_parameters}
\title{Derive conditional multivariate normal parameters}
\usage{
get_conditional_parameters(pars, values)
}
\arguments{
\item{pars}{a \code{list} with elements \code{mu} and \code{sigma} defining the mean vector and
covariance matrix respectively.}

\item{values}{a vector of observed values to condition on, must be same length as \code{pars$mu}.
Missing values must be represented by an \code{NA}.}
}
\value{
A list with the conditional distribution parameters:
\itemize{
\item \code{mu} - The conditional mean vector.
\item \code{sigma} - The conditional covariance matrix.
}
}
\description{
Takes parameters for a multivariate normal distribution and observed values
to calculate the conditional distribution for the unobserved values.
}
