% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkRpcs.R
\name{ping}
\alias{ping}
\title{RPC-JSON API: ping}
\usage{
ping(con)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Requests that a ping be sent to all other nodes, to measure ping time.
Results provided in getpeerinfo, pingtime and pingwait fields are
decimal seconds. Ping command is handled in queue with all other commands,
so it measures processing backlog, not just network ping.
}
\references{
\url{https://bitcoin.org/en/developer-reference#ping},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Network RPCs: 
\code{\link{addnode}()},
\code{\link{clearbanned}()},
\code{\link{disconnectnode}()},
\code{\link{getaddednodeinfo}()},
\code{\link{getconnectioncount}()},
\code{\link{getnettotals}()},
\code{\link{getnetworkinfo}()},
\code{\link{getpeerinfo}()},
\code{\link{listbanned}()}
}
\author{
Bernhard Pfaff
}
\concept{Network RPCs}
