% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{getmempoolancestors}
\alias{getmempoolancestors}
\title{RPC-JSON API: getmempoolancestors}
\usage{
getmempoolancestors(con, txid, verbose = FALSE)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{txid}{\code{character}, the transaction id (must be in mempool).}

\item{verbose}{\code{logical}, \code{TrueTRUE} for a json object,
\code{FALSE} for array of transaction ids (default).}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
If txid is in the mempool, returns all in-mempool ancestors.
}
\references{
\url{https://bitcoin.org/en/developer-reference#getmempoolancestors},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: 
\code{\link{decodescript}()},
\code{\link{getbestblockhash}()},
\code{\link{getblockchaininfo}()},
\code{\link{getblockcount}()},
\code{\link{getblockhash}()},
\code{\link{getblockheader}()},
\code{\link{getblock}()},
\code{\link{getchaintips}()},
\code{\link{getchaintxstats}()},
\code{\link{getdifficulty}()},
\code{\link{getmempooldescendants}()},
\code{\link{getmempoolentry}()},
\code{\link{getmempoolinfo}()},
\code{\link{getrawmempool}()},
\code{\link{gettxoutproof}()},
\code{\link{gettxoutsetinfo}()},
\code{\link{gettxout}()},
\code{\link{pruneblockchain}()},
\code{\link{verifychain}()},
\code{\link{verifytxoutproof}()}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
