% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllipticCurves.R
\docType{methods}
\name{containsPoint}
\alias{containsPoint}
\alias{containsPoint,ECPARAM,bigz,bigz-method}
\alias{containsPoint,ECPARAM,integer,integer-method}
\alias{containsPoint,ECPARAM,character,character-method}
\title{containsPoint-methods}
\usage{
containsPoint(curve, x, y)

\S4method{containsPoint}{ECPARAM,bigz,bigz}(curve, x, y)

\S4method{containsPoint}{ECPARAM,integer,integer}(curve, x, y)

\S4method{containsPoint}{ECPARAM,character,character}(curve, x, y)
}
\arguments{
\item{curve}{an S4-object of class \code{ECPARAM}.}

\item{x}{an S4-object of class \code{bigz}, the x-coordinate.}

\item{y}{an S4-object of class \code{bigz}, the y-coordinate.}
}
\value{
\code{logical}
}
\description{
Checks whether a point is on a defined ellipctic curve.
}
\examples{
p <- "0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"
b <- "0x0000000000000000000000000000000000000000000000000000000000000007"
a <- "0x0000000000000000000000000000000000000000000000000000000000000000"
curve256 <- ecparam(p, a, b)
Gx <- "0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798"
Gy <- "0x483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8"
containsPoint(curve256, Gx, Gy)
}
\references{
\url{https://en.bitcoin.it/wiki/Secp256k1}
}
\seealso{
Other EllipticCurve: 
\code{\link{ECPARAM-class}},
\code{\link{ECPOINT-class}},
\code{\link{EcparamOrNull-class}},
\code{\link{ecoperators}},
\code{\link{ecparam}()},
\code{\link{ecpoint}()},
\code{\link{isNull}()}
}
\author{
Bernhard Pfaff
}
\concept{EllipticCurve}
