% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{set.initvals}
\alias{set.initvals}
\title{Set initial values for the Bacon MCMC run.}
\usage{
set.initvals(set = get("info"), core = set$core, values = c(), click = 1)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{core}{The name of the core for which a bacon.init file needs to be made}

\item{values}{use this if you wish to provide the values (2 rows with starting age, accumulation rates for each model section, and memory parameter w).}

\item{click}{use this if you wish to use the cursor to manually select age-depth points from the current graphic device. This is the default option. Right click once you have selected all datapoints, or provide the number of expected datapoints as a value (e.g., \code{click=5}).}
}
\value{
A .bacon.init file
}
\description{
Select initial values th0 and th1 for a Bacon MCMC run and write them into a file that can be read by Bacon.
}
\details{
By default, the initial MCMC values th0 and th1 of the Bacon age-depth model (upper ages and accumulation rate
for each model section) are estimated randomly. Since version 3.1.0, these starting values can
also be provided in a file with extension _bacon.init, placed
within the core's folder. This file will need to have two rows,
each for one of the two initial sets of parameters required (the
t-walk requires two starting estimates for all MCMC parameters).
If such a file is found (and correctly formatted), Bacon will use
the values within this file as starting points for the MCMC run.
}
\author{
Maarten Blaauw, J. Andres Christen
}
