% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bacon.R
\name{scissors}
\alias{scissors}
\title{Remove the first n iterations.}
\usage{
scissors(burnin, set = get("info"))
}
\arguments{
\item{burnin}{Number of iterations to remove. If this value is higher than the amount of remaining iterations, 
a warning is given and the iterations are not removed.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}
}
\value{
NA
}
\description{
Removes the first n iterations of the MCMC time series, and then updates the output file.
}
\details{
Bacon will perform millions of MCMC iterations for each age-model run by default, although only a fraction 
of these will be stored. In most cases the remaining MCMC iterations will be well mixed (the upper left panel 
of the fit of the iterations shows no undesirable features such as trends or sudden systematic drops or rises).
If the run has a visible remaining burn-in, scissors can be used to remove them. 
To remove, e.g., the first 300 iterations, type \code{scissors(300)}. 
This will remove these iterations in the run's output file.
}
\examples{
\dontshow{
  Bacon(run=FALSE, coredir=tempfile())
  scissors(100)
  agedepth(d.res=50, yr.res=50, d.by=10)
}
\donttest{
  Bacon(ask=FALSE, coredir=tempfile())
  scissors(100)
  agedepth()
}

}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive 
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474. 
\url{https://projecteuclid.org/download/pdf_1/euclid.ba/1339616472}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
