% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{mesh3d_model}
\alias{mesh3d_model}
\title{`mesh3d` model}
\usage{
mesh3d_model(
  mesh,
  x = 0,
  y = 0,
  z = 0,
  swap_yz = FALSE,
  reverse = FALSE,
  scale_mesh = 1,
  verbose = FALSE,
  override_material = FALSE,
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{mesh}{A `mesh3d` or `shapelist3d` object. Pulls the vertex, index, texture coordinates, 
normals, and material information. If the material references an image texture, the 
`mesh$material$texture` argument should be set to the image filename. The `mesh3d` format
only supports one image texture per mesh. All quads will be triangulated.}

\item{x}{Default `0`. x-coordinate to offset the model.}

\item{y}{Default `0`. y-coordinate to offset the model.}

\item{z}{Default `0`. z-coordinate to offset the model.}

\item{swap_yz}{Default `FALSE`. Swap the Y and Z coordinates.}

\item{reverse}{Default `FALSE`. Reverse the orientation of the indices, flipping their normals.}

\item{scale_mesh}{Default `1`. Amount to scale the size of the mesh in all directions.}

\item{verbose}{Default `FALSE`. If `TRUE`, prints information about the mesh to the console.}

\item{override_material}{Default `FALSE`. If `TRUE`, overrides the material specified in the 
`mesh3d` object with the one specified in `material`.}

\item{material}{Default  \code{\link{diffuse}}.The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the mesh3d model in the scene.
}
\description{
Load an `mesh3d` (or `shapelist3d`) object, as specified in the `rgl` package.
}
\examples{
#Load a mesh3d object (from the Rvcg) and render it:
if(length(find.package("Rcvg", quiet=TRUE)) > 0) {
  library(Rvcg)
  data(humface)
  
  generate_studio() \%>\% 
    add_object(mesh3d_model(humface,y=-0.3,x=0,z=0,
                          material=glossy(color="dodgerblue4"), scale_mesh = 1/70)) \%>\%
    add_object(sphere(y=5,x=5,z=5,material=light(intensity=50))) \%>\% 
    render_scene(samples=500,width=800,height=800,
                 lookat = c(0,0.5,1), aperture=0.0)
}
}
