% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CasColNames.R
\name{CasColNames}
\alias{CasColNames}
\title{CAS Column Names}
\usage{
CasColNames(df, restore = TRUE)
}
\arguments{
\item{df}{A data frame of loss reserving data}

\item{restore}{Boolean indicating whether to restore the names defined by Meyers and Shi. The default is true.}
}
\value{
A data frame with different column names.
}
\description{
This will change the column names of a data frame obtained from the CAS database of reserve triangles. This data was 
procured and modified by Glenn G. Meyers and Peng Shi and is hosted by the CAS. More information on the data is available here: 
\href{http://www.casact.org/research/index.cfm?fa=loss_reserves_data}{http://www.casact.org/research/index.cfm?fa=loss_reserves_data}
}
\examples{

\dontrun{
data(NJM_WC)
NJM_WC <- CasColNames(NJM_WC, restore = TRUE)
}

}
