% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-utils.R
\name{check_filter}
\alias{check_filter}
\title{Check 'Arma' filter}
\usage{
check_filter(b, a, w = NULL, r_expected = NULL, fs = NULL)
}
\arguments{
\item{b}{moving average (\code{MA}) polynomial coefficients.}

\item{a}{auto-regressive (\code{AR}) polynomial coefficients.}

\item{w}{normalized frequency, ranging from 0 to 1, where 1 is 'Nyquist'}

\item{r_expected}{attenuation in decibel of each \code{w}}

\item{fs}{sample rate, used to infer the frequencies and formatting print
message, not used in calculation; leave it blank by default}
}
\value{
A list of power estimation and the reciprocal condition number
of the \code{AR} coefficients.
}
\description{
Check 'Arma' filter
}
\examples{


# create a butterworth filter with -3dB (half-power) at [1, 5] Hz
# and -60dB stop-band attenuation at [0.5, 6] Hz

sample_rate <- 20
nyquist <- sample_rate / 2

specs <- buttord(
  Wp = c(1, 5) / nyquist,
  Ws = c(0.5, 6) / nyquist,
  Rp = 3,
  Rs = 60
)
filter <- butter(specs)

# filter quality is poor because the AR-coefficients
# creates singular matrix with unstable inverse,
# this will cause `filtfilt` to fail
check_filter(
  b = filter$b, a = filter$a,

  # frequencies (normalized) where power is evaluated
  w = c(1, 5, 0.5, 6) / nyquist,

  # expected power
  r_expected = c(3, 3, 60, 60)

)


}
