% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-format.R
\name{combine_n_pct}
\alias{combine_n_pct}
\title{Combine N and Percent Columns for Accessibility}
\usage{
combine_n_pct(df, n, pct, name, remove = TRUE, na_replace = NULL)
}
\arguments{
\item{df}{A data frame that has already been sent to \code{\link[=fmt_table]{fmt_table()}}}

\item{n}{The unquoted name of the column containing count values}

\item{pct}{The unquoted name of the column containing percentage values}

\item{name}{The name of the new combined column to be created}

\item{remove}{Logical. Should the existing \code{n} and \code{pct} columns be removed?}

\item{na_replace}{Character string representing how missing values should be
represented.}
}
\value{
A data frame.
}
\description{
Combine N and Percent Columns for Accessibility
}
\examples{
pcts <- tibble::tibble(Program = c("A", "B", "C", "D", "E", "F"),
               n = 0:5,
               p = 0.5 * (0:5))
pcts |>
  fmt_table() |>
  combine_n_pct(n = n, pct = p, name = "States")

}
