% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asp_ratio.R
\name{asp_ratio}
\alias{asp_ratio}
\title{Compute aspect ratio of an object}
\usage{
asp_ratio(x)
}
\arguments{
\item{x}{A \code{SpatRaster} object, an \code{sf/sfc} object or a numeric vector of
length 4 with coordinates c(\code{xmin}, \code{ymin}, \code{xmax}, \code{ymax}), as created by
\code{\link[sf:st_bbox]{sf::st_bbox()}}.}
}
\value{
The aspect ratio
}
\description{
Helper function. Ratio is computed as width/height (or col/rows).
}
\examples{

library(terra)

x <- rast(system.file("tiff/elev.tiff", package = "rasterpic"))
plot(x)
asp_ratio(x)
}
\keyword{internal}
