% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{static}
\alias{static}
\alias{rasterlyGrob}
\alias{grid.rasterly}
\alias{plot.rasterly}
\alias{print.rasterly}
\title{Annotate and customize rasterly figures}
\usage{
rasterlyGrob(
  rasterlyObj,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  interpolate = FALSE,
  axes = TRUE,
  legend = TRUE,
  legend_label = NULL,
  legend_layer = 1,
  legend_main = NULL,
  axes_gpar = grid::gpar(col = "black", cex = 1),
  label_gpar = grid::gpar(col = "black", cex = 1),
  main_gpar = grid::gpar(col = "black", cex = 1.5),
  legend_gpar = grid::gpar(col = "black", cex = 1.5),
  name = NULL,
  gp = NULL,
  vp = NULL
)

grid.rasterly(
  rasterlyObj,
  interpolate = FALSE,
  axes = TRUE,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  legend = TRUE,
  legend_label = NULL,
  legend_layer = 1,
  legend_main = NULL,
  axes_gpar = grid::gpar(col = "black", cex = 1),
  label_gpar = grid::gpar(col = "black", cex = 1),
  main_gpar = grid::gpar(col = "black", cex = 1.5),
  legend_gpar = grid::gpar(col = "black", cex = 1.5),
  name = NULL,
  gp = NULL,
  vp = NULL,
  ...
)

\method{plot}{rasterly}(
  x,
  y = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  legend_main = NULL,
  sub = NULL,
  interpolate = FALSE,
  axes = TRUE,
  legend = TRUE,
  legend_label = NULL,
  legend_layer = 1,
  new.page = TRUE,
  ...
)

\method{print}{rasterly}(x, ...)
}
\arguments{
\item{rasterlyObj}{A \code{rasterly} object.}

\item{xlim}{Numeric; the x limits (x1, x2) of the plot. Default is \code{NULL}.}

\item{ylim}{Numeric; the y limits (y1, y2) of the plot. Default is \code{NULL}.}

\item{xlab}{Character; the label to be used for the \code{x} axis. Default is \code{NULL}.}

\item{ylab}{Character; the label to be used for the \code{y} axis. Default is \code{NULL}.}

\item{main}{Character; the title to be used for the plot. Default is \code{NULL}.}

\item{sub}{sub Character; a subtitle for the plot. Default is \code{NULL}.}

\item{interpolate}{Logical. Linearly interpolates the image if \code{TRUE}. Default is \code{FALSE}.}

\item{axes}{Logical; should axes be drawn? Default is \code{TRUE}, set to \code{FALSE} to hide axes.}

\item{legend}{Logical. Show a figure legend? Default is \code{TRUE}; set to \code{FALSE} to hide the legend.}

\item{legend_label}{Character. The label to apply to the figure legend. Default is \code{NULL}, which omits the figure legend label.}

\item{legend_layer}{Numeric. Specify the layer level within the \code{rasterly} object. The default layer level is `1`, which represents the uppermost layer.}

\item{legend_main}{Character. The main title to use within the figure legend. The default is \code{NULL}, which omits the figure legend title.}

\item{axes_gpar}{Object of class \code{gpar}. This graphical parameter (\code{\link{gpar}}) controls axis color, size, and other aesthetics.}

\item{label_gpar}{Object of class \code{gpar}. This graphical parameter (\code{\link{gpar}}) controls label color, size, and other aesthetics.}

\item{main_gpar}{Object of class \code{gpar}. This graphical parameter (\code{\link{gpar}}) controls the main title's color, size, and other aesthetics.}

\item{legend_gpar}{Object of class \code{gpar}. This graphical parameter (\code{\link{gpar}}) controls the legend's color, size, and other aesthetics.}

\item{name}{Character. An identifier used to locate the \code{\link{grob}} within the display list and/or as a child of another grob.}

\item{gp}{A \code{\link{gpar}} object, typically the output from a call to the function \code{grid::gpar}. This argument represents a list of graphical parameter settings.}

\item{vp}{Object of class \code{\link{viewport}}. If provided, \code{\link{rasterlyGrob}} will pass this argument through to \code{grob}. Default is \code{NULL}.}

\item{...}{Other arguments to modify the display.}

\item{x}{A \code{rasterly} object}

\item{y}{NULL, will be ignored.}

\item{new.page}{display on a new page or not.}
}
\description{
Create a static plot based on \code{rasterly} object. 
This function allows users to add axes, legends and other descriptive details when generating `rasterly` objects.
}
\details{
We provide three functions to produce static graphics, which is based on the API of \code{grid}, \code{plot} and \code{print}.
\itemize{
 \item{\code{grid}: The \code{rasterlyGrob} and \code{grid.rasterly} are the most flexible data structure. 
 These functions produce a **\code{grob}** object. Users can modify the existing display by the functions provided by \code{grid}}.
 \item{\code{plot.rasterly}: The usage of this S3 method is very similar to the classic \code{\link{plot}} function.
  Users can set axis limits via \code{xlim}  and \code{ylim}, as well as the corresponding labels using \code{xlab} and \code{ylab}, among other attributes.}
 \item{\code{print.rasterly}: This S3 method returns only a basic image raster.}
}
}
\examples{
if(requireNamespace("grid")) {
  data <- data.frame(x = rnorm(1e6), 
                     y = rexp(1e6, 10))
  # a rasterly object
  rasterlyObj <- data \%>\% 
                   rasterly(mapping = aes(x = x, y = y)) \%>\% 
                   rasterly_points()
  # Generate a grob
  rg <- rasterlyGrob(rasterlyObj)
  ## get the raster grob by `grid::getGrob()`
  grid::getGrob(rg, "raster")
  grid::grid.newpage()
  grid::grid.draw(rg)
  # or
  grid::grid.newpage()
  grid.rasterly(rasterlyObj)
  # or `plot`
  plot(rasterlyObj, xlab = "rnorm(1e6)", 
       ylab = "rexp(1e6, 10)", 
       main = "This is an arbitrary plot")
  # or simply print
  rasterlyObj 
  ## it is equivalent to `print(rasterlyObj)`
}

}
\seealso{
\code{\link{plotRasterly}}, \code{\link{ggRasterly}}
}
