% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listdata_bc.R
\name{listdata_bc}
\alias{listdata_bc}
\title{List all available layers, or their associated filepaths and download status}
\usage{
listdata_bc(
  collection = NULL,
  varname = NULL,
  year = NULL,
  verbose = 1,
  simple = FALSE
)
}
\arguments{
\item{collection}{(Optional) character string, indicating the data collection to query}

\item{varname}{(Optional) character string, indicating the layer to query (see Details, below)}

\item{year}{(Optional) integer or character string, indicating the year to query (see Details, below)}

\item{verbose}{An integer (0, 1, 2), indicating how much information about the files to print to the console}

\item{simple}{logical indicating to return a (list of) logical vector(s) indicating existence on disk of specific filenames}
}
\value{
Either a (list of) dataframe(s) containing information about each raster layer, or (when \code{simple==TRUE}) a
nested list of logical values (named according to filepath), with entries for each data file in the specified subset.
}
\description{
Returns a list of dataframes (one per collection) describing the variables available through rasterbc, or a subset (as
specified by \code{collection}, \code{varname}, \code{year}). Alternatively, if \code{simple==TRUE}, returns a nested list indicating
the filepaths associated with these layers, and which of them exist in the local data storage directory already.
}
\details{
The layers available through this package are organized into "collections", corresponding to their original online sources.
Layers in a collection are further organized by variable name, and are uniquely identified by the character string \code{varname}
(and, if applicable, \code{year}). The optional arguments \code{collection}, \code{varname}, \code{year} prompt this function to return only the
applicable subsets.
}
\examples{
# print available collections
listdata_bc() |> names()

# print info about a specific collection
listdata_bc('bgcz')
listdata_bc('bgcz', verbose=2)

# example with a year field
listdata_bc('fids', varname='IBM_mid', year=2005, verbose=2)
listdata_bc('fids', varname='IBM_mid', verbose=2)

# "simple=TRUE" mode returns logical vector indicating which mapsheets are downloaded
listdata_bc(collection='dem', varname='aspect', verbose=2, simple=TRUE)
}
