\name{reclass}

\docType{methods}

\alias{reclass}
\alias{reclass,Raster-method}

\title{Reclassify}

\description{
Reclassify values of a Raster* object. The function (re)classifies groups of values to other values. E.g. All values between 1 and 10 become 1, and all values between 11 and 15 become 2. 

Reclassification is done with matrix "rcl". For simple cases, the functions \code{\link{subs}} and \code{\link{cut}} may be more efficient.

Reclassification is done in the order of the reclass table. Thus, if there are overlapping ranges, the last range applies.  
}

\usage{
reclass(x, rcl, ...) 
}

\arguments{
  \item{x}{A Raster* object}
  \item{rcl}{Matrix for reclassifcation. This matrix must have 3 columns. The first two columns are "from" "to" of the input values, and the third column has the new value for that range. (You can also supply a vector that can be coerced into a n*3 matrix (with byrow=TRUE))}
  \item{...}{additional arguments. See Details.}  
}

\details{

The following additional arguments can be passed, to replace default values for this function
\tabular{rll}{
 \tab \code{include.lowest} \tab logical, indicating if a value equal to the lowest value in rcl (or highest value in the second column, for right = FALSE) should be included. The default is \code{FALSE} \cr
 \tab \code{right} \tab logical, indicating if the intervals should be closed on the right (and open on the left) or vice versa. The default is \code{TRUE} \cr
}

You can also use these additional arguments to save the result to a file
\tabular{rll}{
  \tab \code{filename} \tab Output filename (can be absent for RasterLayers that can be stored in memory) \cr
  \tab \code{format}  \tab Character. Output file type. See \code{\link[raster]{writeRaster}} \cr
  \tab \code{datatype}  \tab Character. Output data type; can be 'INT', 'FLT', or a complete datatype description, see \code{\link[raster]{dataType}} \cr
  \tab \code{overwrite} \tab Logical. If \code{TRUE}, "filename" will be overwritten if it exists \cr
  \tab \code{progress}  \tab Character. "text", "window", or "" (the default, no progress bar)  \cr
 }
}


\value{
Raster* object
}

\seealso{ \code{ \link{subs}, \link{cut}, \link{calc}} } 


\author{Robert J. Hijmans}

\examples{

r <- raster(ncols=36, nrows=18)
r[] <- runif(ncell(r)) 
# reclassify the values into three groups 
# all values >= 0 and <= 0.25 become 1, etc.
m <- c(0, 0.25, 1,  0.25, 0.5, 2,  0.5, 1, 3)
rclmat <- matrix(m, ncol=3, byrow=TRUE)
rc <- reclass(r, rclmat)

# equivalent to
rc <- reclass(r, c(-Inf,0.25,1, 0.25,0.5,2, 0.5,Inf,3))
}

\keyword{spatial}
