% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observation.r
\name{observation}
\alias{observation}
\title{Select the Representative Response Observation for Stratification Units}
\usage{
observation(
  su.rast,
  obs,
  col.id,
  col.resp,
  method = "mls",
  ls.rast,
  verbose = FALSE
)
}
\arguments{
\item{su.rast}{SpatRaster, as in \code{\link[terra]{rast}}. Single-layer
SpatRaster representing the stratification units occurring across
geographic space. Integer values are expected as cell values (i.e., numeric
codes) of stratification units.}

\item{obs}{SpatVector, as in \code{\link[terra]{vect}}. Vector of point
geometry whose tabular attributes should contain an ID column (1,2,...,n)
and a column of the response' values.}

\item{col.id}{Integer. Index of the ID column in the tabular attributes of
\emph{obs}.}

\item{col.resp}{Integer. Index of the response' values column in the tabular
attributes of \emph{obs}.}

\item{method}{Character. String specifying the selection method for the
response representative observation. Options are "mls" for the maximum
landscape similarity value, "mrv" for the median response value, and
"random" for random selection. Default: "mls"}

\item{ls.rast}{SpatRaster, as in \code{\link[terra]{rast}}. Multi-layer
SpatRaster representing landscape similarities to stratification units.
Only required if \emph{method = "mls"}.}

\item{verbose}{Boolean. Show warning messages in the console? Default: FALSE}
}
\value{
A list with the following components:

\strong{su.repobs}: Data table with the following attributes: (1) Original
IDs of the selected observation, (2) representative response value, (3)
stratification unit's numeric code, and (4) landscape similarity value at the
\emph{XY} location of the selected observation (only if \emph{method =
"mls"}).

\strong{su.norepobs}: List of the numeric codes of stratification units
without observations.

\strong{su.repobs.sp}: SpatVector of point geometry with the representative
response observation for each stratification unit represented in
\emph{su.rast}.
}
\description{
Selection of the \emph{representative response observation} for each
stratification unit occurring across geographic space. One observation from a
set of \emph{n} observations of a response variable sampled/measured within
the spatial boundaries of a given stratification unit is selected according
to the following criteria: (1) \emph{maximum landscape similarity}, (2)
\emph{median response value}, and (3) \emph{random selection}. The maximum
landscape similarity (mls) selects the observation at the \emph{XY} spatial
location where the landscape similarity value is maximized for a given
stratification unit. The median response value (mrv) selects the observation
whose response value is (closest to) the median of all response values, as
measured from the observations spatially enclosed by a given stratification
unit. The random selection, as implied by the name, randomly selects one
observation from the set of observations spatially enclosed by a given
stratification unit. See \strong{Details} for some guidance in the use of this
function for classification units.
}
\details{
This selection scheme can be applied to classification units. For
classification units, one should replace the multi-layer SpatRaster of
landscape similarities with a multi-layer SpatRaster of spatial signatures. One
should also replace the raster layer of stratification units with that of
classification units.
}
\examples{
require(terra)
p <- system.file("exdat", package = "rassta")
# Single-layer SpatRaster of stratification units
fsu <- list.files(path = p, pattern = "strata.tif", full.names = TRUE)
su <- terra::rast(fsu)
# Observations with response values.
## For this example, soil organic carbon (SOC) collected at 15 cm soil depth
fob <- list.files(path = p, pattern = "soc.shp", full.names = TRUE)
ob <- terra::vect(fob)
# Column indices for ID and measured response value
id <- 1
re <- 2
# Multi-layer SpatRaster of landscape similarities
fls <- list.files(path = p, pattern = "su_", full.names = TRUE)
ls <- terra::rast(fls)
# Selection of representative response observations for stratification units
ro <- observation(su.rast = su, obs = ob, col.id = id, col.resp = re,
                  ls.rast = ls
                 )
# Plot representative observations
if(interactive()){plot(su, type = "classes",
                       fun = function() points(ro$su_repobs.sp)
                      )}

}
\seealso{
\code{\link{strata}}, \code{\link{similarity}}

Other Functions for Stratified Sampling: 
\code{\link{locations}()}
}
\concept{Functions for Stratified Sampling}
