% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rap.R
\name{rap}
\alias{rap}
\title{Generate prioritisations using RAP}
\usage{
rap(pus, species, spaces = NULL, formulation = "unreliable", solve = TRUE,
  ...)
}
\arguments{
\item{pus}{\code{SpatialPolygons} object representing planning units.}

\item{species}{\code{RasterLayer} object with species distribution data.}

\item{spaces}{\code{list} of \code{RasterLayer} or \code{RasterStack} objects. Each elements denotes the spatial distribution for each space. Defaults to \code{NULL}.}

\item{formulation}{\code{character}  to indicate if 'unreliable' or 'reliable' formulation should be used to generate prioritisations. Defaults to 'unreliable'.}

\item{solve}{\code{logical} should solutions be generated?}

\item{...}{arguments are passed to \code{\link{GurobiOpts}}, \code{\link{make.RapData}}, and \code{\link{RapReliableOpts}} or \code{\link{RapUnreliableOpts}} functions.}
}
\value{
\code{\link{RapSolved}} object if \code{solve} is \code{TRUE}, else \code{\link{RapUnsolved}}.
}
\description{
This is a general function to create Rap objects from scratch and solve them to generate solutions.
}
\note{
Type \code{vignette('raptr')} to see the package vignette for help.
}
\seealso{
\code{\link{GurobiOpts}}, \code{\link{RapReliableOpts}}, \code{\link{RapUnreliableOpts}} \code{\link{RapData}}, \code{\link{RapResults}}, \code{\link{RapUnsolved}}, \code{\link{RapSolved}}.
}

