% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormean.R
\name{cormean}
\alias{cormean}
\title{Compute a minimally biased average of correlation values}
\usage{
cormean(
  r,
  n,
  weights = c("none", "n", "df"),
  type = c("OP5", "OP2", "OPK"),
  na.rm = FALSE,
  incl.trans = FALSE
)
}
\arguments{
\item{r}{A vector containing correlation values/}

\item{n}{A single value or vector containing sample sizes/}

\item{weights}{Character. How should the correlations be weighted?
\code{none} leads to no weighting, \code{n} weights by sample size,
\code{df} weights by sample size minus one.}

\item{type}{Character. Determines which averaging algorithm to use, 
with "OP5" usually being the most accurate.}

\item{na.rm}{Logical. Should missing values be removed?}

\item{incl.trans}{Logical. Should the transformed correlations be included?}
}
\value{
An average correlation.
}
\description{
This function computes a minimally biased average of correlation values.
This is needed because simple averaging of correlations is negatively biased,
and the often used z-transformation method of averaging correlations is positively biased.
The algorithm was developed by Olkin & Pratt (1958).
}
\examples{
cormean(c(0,.3,.5),c(30,30,60))

}
\references{
Olkin, I., & Pratt, J. (1958). Unbiased estimation of certain correlation coefficients.
The Annals of Mathematical Statistics, 29. https://doi.org/10.1214/aoms/1177706717

Shieh, G. (2010). Estimation of the simple correlation coefficient. Behavior Research Methods,
42(4), 906-917. https://doi.org/10.3758/BRM.42.4.906
}
