% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{raceIAT}
\alias{raceIAT}
\title{Implicit Association Task examining implicit bias towards White and Black people}
\format{
An object of class \code{"data.frame"}.
}
\source{
\href{https://osf.io/y9hiq/}{OSF.io repository}
}
\usage{
data(raceIAT)
}
\description{
This data originates from the publicly available
implicit association test (IAT) on racial prejudice hosted by Project Implicit.
200 participants were randomly sampled from the full trial-level data
available for participants from 2002 to 2022.
We included only those IAT blocks relevant to scoring (3,4,6,7) and
only individuals with full data.
}
\details{
\itemize{
\item session_id: The session id, proxy for participant number.
\item task_name: Subtype of IAT used.
\item block_number: IAT block number.
\item block_pairing_definition: Stimulus pairing displayed in block.
\item block_trial_number: Trial number within block.
\item stimulus: Stimulus name.
\item required_response: The response required from the participant.
\item latency: Participant's response latency.
\item error: Whether the response was wrong (\code{TRUE}).
\item trial_number: Experimentwise trial number.
\item stimcat: The stimulus category.
\item respcat: Category of the required response.
\item blocktype: Either practice block or full IAT block.
\item congruent: Whether the block was congruent with anti-black bias (\code{TRUE}) or not.
\item latency2: Response latencies with those for incorrect responses
replaced by the block mean plus a penalty.
}
}
\references{
Xu, K., Nosek, B., & Greenwald, A. G. (2014).
Psychology data from the race implicit association test on the project implicit demo website.
Journal of open psychology data, 2(1), e3-e3.
\doi{10.5334/jopd.ac}
}
\keyword{datasets}
