% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bootstrapWeights}
\alias{bootstrapWeights}
\title{Bootstrap Weights}
\usage{
bootstrapWeights(size, times)
}
\arguments{
\item{size}{Number of values to bootstrap}

\item{times}{Number of bootstraps}
}
\value{
A matrix with bootstrap samples expressed as frequency weights. 
Each column represents a single bootstrap iteration and each row represents a case.
}
\description{
Create a matrix of bootstrap samples expressed as frequency weights
}
\examples{
# Rapidly compute a bootstrapped median to obtain its standard error
myweights<-bootstrapWeights(size=50, times=100)
meds<-mediansByWeight(x=rnorm(50),weights=myweights)
# SE
sd(meds)

}
