% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userAttribute.R
\name{userAttribute}
\alias{userAttribute}
\alias{getUserEmail}
\alias{getUserFullName}
\alias{getUserGroups}
\alias{getUserName}
\alias{getUserPhone}
\alias{getUserReshId}
\alias{getUserRole}
\title{User attributes in container apps running behind shinyproxy}
\usage{
userAttribute(group, unit = NULL)

getUserEmail(shinySession = NULL, group = NULL)

getUserFullName(shinySession = NULL, group = NULL)

getUserGroups(shinySession = NULL, group = NULL)

getUserName(shinySession = NULL, group = NULL)

getUserPhone(shinySession = NULL, group = NULL)

getUserReshId(shinySession = NULL, group = NULL)

getUserRole(shinySession = NULL, group = NULL)
}
\arguments{
\item{group}{Character string providing the name of the app R package name.
The term "group" is used to relate to the environmental variable
SHINYPROXY_USERGROUPS that corresponds to the apps a given user can access.
Default value is NULL but should always be set when shiny app is run as a
shinyproxy container.}

\item{unit}{Integer providing the look-up unit id. Default value is NULL in
which case all privileges for \code{group} are returned.}

\item{shinySession}{A shiny session object. Default value is NULL}
}
\value{
Invisibly a list of user metadata and privileges:
  \describe{
    \item{name}{The username for whom the privileges apply.}
    \item{fullName}{User full name}
    \item{phone}{User phone number}
    \item{email}{User email}
    \item{group}{Group of which the user is a member.}
    \item{unit}{Unit id under which the privileges are defined.}
    \item{org}{Organization id for the user.}
    \item{role}{Role of the user.}
    \item{orgName}{Name of the organization as defined under the unit id.}
  }

String with user attribute
}
\description{
For apps running as containers particular environment variables must be
defined for an orderly handling of dynamic user privileges. This function
makes use of environmental variables defined by shinyproxy to provide
available privileges for the shiny application.

These are helper function for \code{\link{userInfo}}. When used without a
shiny session object calls to these functions is made without any arguments.
If redefining contexts is needed, please use \code{\link{userInfo}} instead.
}
\examples{
\donttest{
# Requires a valid shiny session object
try(getUserEmail())
try(getUserEmail(shinySessionObject))
}
}
