% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleNavbarWidget.R
\name{navbarWidget}
\alias{navbarWidget}
\alias{navbarWidgetInput}
\alias{navbarWidgetServer}
\alias{navbarWidgetApp}
\title{Shiny modules providing GUI and server logic for user info widget}
\usage{
navbarWidgetInput(id, addUserInfo = TRUE)

navbarWidgetServer(id, orgName, caller = environmentName(rlang::caller_env()))

navbarWidgetApp(orgName = "Org Name")
}
\arguments{
\item{id}{Character string providing module namespace}

\item{addUserInfo}{Logical defining if an "about" hyperlink is to be added}

\item{orgName}{Character string naming the organization}

\item{caller}{Character string naming the environment this function was
called from. Default value is \code{environmentName(rlang::caller_env())}.
The value is used to display the current version of the R package
representing the registry at Rapporteket. If this module is called from
exported functions in the registry R package use the default value. If the
module is called from outside the registry environment \code{caller} must be
set to the actual name of the R package.}
}
\value{
Shiny objects, mostly. Helper functions may return other stuff too.
}
\description{
Shiny modules for making a user information widget in registry shiny apps at
Rapporteket. One benefit using these modules will be reduced complexity and
number of code lines for each registry.
}
\details{
These modules take use of the shiny session object to obtain data for the
widget. Hence, a Rapporteket like context will be needed for these modules to
function properly.
}
\examples{
## client user interface function
ui <- shiny::tagList(
  shiny::navbarPage(
    "Testpage",
    shiny::tabPanel(
      "Testpanel",
      shiny::mainPanel(
        navbarWidgetInput("testWidget")
      )
    )
  )
)

## server function
server <- function(input, output, session) {
  navbarWidgetServer("testWidget", orgName = "Test org", caller = "Rpkg")
}

## run the app in an interactive session and a Rapporteket like environment
if (interactive() && isRapContext()) {
  shiny::shinyApp(ui, server)
}
}
